/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.panel.TabbedPanel;
import com.tcdng.unify.web.ui.widget.writer.AbstractSwitchPanelWriter;
import java.util.ArrayList;

@Writes(value=TabbedPanel.class)
@Component(value="tabbedpanel-writer")
public class TabbedPanelWriter
extends AbstractSwitchPanelWriter {
    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        TabbedPanel tabbedPanel = (TabbedPanel)widget;
        writer.beginFunction("ux.rigTabbedPanel");
        writer.writeParam("pId", tabbedPanel.getId());
        writer.writeParam("pContId", tabbedPanel.getId());
        writer.writeCommandURLParam("pCmdURL");
        writer.writeParam("pActTabId", tabbedPanel.getActiveTabId());
        writer.writeParam("pActTabIdList", (String[])DataUtils.toArray(String.class, tabbedPanel.getActiveTabExpandedIdList()));
        writer.writeParam("pSelTabId", tabbedPanel.getSelectedTabId());
        writer.writeParam("pTabIdList", (String[])DataUtils.toArray(String.class, tabbedPanel.getTabIds()));
        ArrayList<String> captionIds = new ArrayList<String>();
        for (String longName : tabbedPanel.getLayoutWidgetLongNames()) {
            Widget tabWidget = tabbedPanel.getWidgetByLongName(longName);
            if (tabWidget.isHidden() || !tabWidget.isVisible()) continue;
            captionIds.add(tabWidget.getPrefixedId("cap_"));
        }
        writer.writeParam("pTabCapIdList", (String[])DataUtils.toArray(String.class, captionIds));
        writer.endFunction();
    }

    @Override
    protected void writeLayoutContent(ResponseWriter writer, Container container) throws UnifyException {
        TabbedPanel tabbedPanel = (TabbedPanel)container;
        writer.writeStructureAndContent(tabbedPanel.getSelectedTabIdCtrl());
        switch (tabbedPanel.getTabPosition()) {
            case BOTTOM: {
                writer.write("<div class=\"tbottom\">");
                writer.write("<div style=\"display:table-row;height:100%;\"><div style=\"display:table-cell;\">");
                this.writeContent(writer, tabbedPanel);
                writer.write("</div></div>");
                writer.write("<div style=\"display:table-row;\"><div style=\"display:table-cell;\">");
                this.writeTabs(writer, tabbedPanel);
                writer.write("</div></div>");
                writer.write("</div>");
                break;
            }
            case LEFT: {
                writer.write("<div class=\"tleft\">");
                writer.write("<div style=\"display:table-row;\"><div style=\"display:table-cell;height:100%;vertical-align:top;\">");
                this.writeTabs(writer, tabbedPanel);
                writer.write("</div>");
                writer.write("<div style=\"display:table-cell;width:100%;height:100%;\">");
                this.writeContent(writer, tabbedPanel);
                writer.write("</div></div>");
                writer.write("</div>");
                break;
            }
            case RIGHT: {
                writer.write("<div class=\"tright\">");
                writer.write("<div style=\"display:table-row;\"><div style=\"display:table-cell;width:100%;height:100%;\">");
                this.writeContent(writer, tabbedPanel);
                writer.write("</div>");
                writer.write("<div style=\"display:table-cell;height:100%;vertical-align:top;\">");
                this.writeTabs(writer, tabbedPanel);
                writer.write("</div></div>");
                writer.write("</div>");
                break;
            }
            default: {
                writer.write("<div class=\"ttop\">");
                writer.write("<div style=\"display:table-row;\"><div style=\"display:table-cell;\">");
                this.writeTabs(writer, tabbedPanel);
                writer.write("</div></div>");
                writer.write("<div style=\"display:table-row;height:100%;\"><div style=\"display:table-cell;\">");
                this.writeContent(writer, tabbedPanel);
                writer.write("</div></div>");
                writer.write("</div>");
            }
        }
    }

    private void writeTabs(ResponseWriter writer, TabbedPanel tabbedPanel) throws UnifyException {
        Widget currentWidget = tabbedPanel.getCurrentWidget();
        writer.write("<ul class=\"ttab\">");
        for (String longName : tabbedPanel.getLayoutWidgetLongNames()) {
            Widget widget = tabbedPanel.getWidgetByLongName(longName);
            if (widget.isHidden() || !widget.isVisible()) continue;
            writer.write("<li id=\"").write(widget.getPrefixedId("cap_")).write("\"");
            if (widget == currentWidget) {
                writer.write("class=\"tactive\"");
            } else {
                writer.write("class=\"tinactive\"");
            }
            writer.write("><a>");
            this.writeCaption(writer, widget);
            writer.write("</a></li>");
        }
        writer.write("</ul>");
    }

    private void writeContent(ResponseWriter writer, TabbedPanel tabbedPanel) throws UnifyException {
        Widget currentWidget = tabbedPanel.getCurrentWidget();
        writer.write("<div class=\"tcontent\">");
        currentWidget = tabbedPanel.getCurrentWidget();
        if (currentWidget != null && currentWidget.isVisible()) {
            writer.writeStructureAndContent(currentWidget);
        }
        writer.write("</div>");
    }
}

