/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.SessionContext;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.logging.EventLogger;
import com.tcdng.unify.core.util.SystemUtils;
import com.tcdng.unify.core.util.ValueStoreUtils;
import com.tcdng.unify.web.Controller;
import com.tcdng.unify.web.ControllerFinder;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.constant.Secured;

public abstract class AbstractController
extends AbstractUnifyComponent
implements Controller {
    @Configurable
    private EventLogger eventLogger;
    @Configurable
    private ControllerFinder controllerFinder;
    private boolean secured;

    public AbstractController(Secured secured) {
        this.secured = secured.isTrue();
    }

    public void setEventLogger(EventLogger eventLogger) {
        this.eventLogger = eventLogger;
    }

    public void setControllerFinder(ControllerFinder controllerFinder) {
        this.controllerFinder = controllerFinder;
    }

    @Override
    public boolean isSecured() {
        return this.secured;
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    protected ValueStore createValueStore(Object sourceObject) throws UnifyException {
        return ValueStoreUtils.getValueStore((Object)sourceObject, null, (int)0);
    }

    protected EventLogger getEventLogger() throws UnifyException {
        return this.eventLogger;
    }

    protected ControllerFinder getControllerFinder() {
        return this.controllerFinder;
    }

    protected void ensureSecureAccess(ControllerPathParts reqPathParts, boolean remoteView) throws UnifyException {
        boolean isUserLoggedIn;
        SessionContext sessionContext = this.getSessionContext();
        boolean bl = isUserLoggedIn = sessionContext.isUserLoggedIn() || remoteView;
        if (this.isSecured() && !isUserLoggedIn) {
            String forceLogout = (String)sessionContext.removeAttribute("UNIFYCORE.FORCELOGOUT");
            if (forceLogout != null) {
                throw new UnifyException(SystemUtils.getSessionAttributeErrorCode((String)forceLogout), new Object[]{reqPathParts.getControllerPath()});
            }
            throw new UnifyException("UW_0010", new Object[]{reqPathParts.getControllerPath()});
        }
    }
}

