/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.AbstractPlainOutputStreamController;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ClientResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class AbstractPlainByteArrayOutputStreamController
extends AbstractPlainOutputStreamController {
    private String disposition;

    public AbstractPlainByteArrayOutputStreamController(MimeType mimeType, String disposition) {
        super(mimeType);
        this.disposition = disposition;
    }

    public AbstractPlainByteArrayOutputStreamController() {
    }

    @Override
    public void doProcess(ClientRequest request, ClientResponse response) throws UnifyException {
        try {
            response.setContentType(this.getContentType());
            if (StringUtils.isNotBlank((String)this.disposition)) {
                response.setMetaData("Content-Disposition", this.disposition);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.doExecute(baos, request);
            baos.flush();
            byte[] data = baos.toByteArray();
            response.setMetaData("Content-Length", String.valueOf(data.length));
            response.getOutputStream().write(data);
        }
        catch (IOException e) {
            this.throwOperationErrorException(e);
        }
    }
}

