/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.stream.JsonObjectStreamer;
import com.tcdng.unify.web.AbstractPlainController;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ClientResponse;
import com.tcdng.unify.web.remotecall.RemoteCallFormat;

public abstract class AbstractPlainJsonController
extends AbstractPlainController {
    @Configurable
    private JsonObjectStreamer jsonObjectStreamer;

    public void setJsonObjectStreamer(JsonObjectStreamer jsonObjectStreamer) {
        this.jsonObjectStreamer = jsonObjectStreamer;
    }

    @Override
    public void doProcess(ClientRequest request, ClientResponse response) throws UnifyException {
        RemoteCallFormat remoteCallFormat = (RemoteCallFormat)((Object)request.getParameter("req_rcf"));
        if (!RemoteCallFormat.JSON.equals((Object)remoteCallFormat)) {
            throw new UnifyException("UW_0011", new Object[]{remoteCallFormat, RemoteCallFormat.JSON, this.getName()});
        }
        response.setContentType(RemoteCallFormat.JSON.mimeType().template());
        String jsonRequest = (String)request.getParameter("req_rcb");
        this.jsonObjectStreamer.marshal(this.doExecute(jsonRequest), response.getWriter());
    }

    protected <T> T getObjectFromRequestJson(Class<T> jsonType, String json) throws UnifyException {
        return (T)this.jsonObjectStreamer.unmarshal(jsonType, json);
    }

    protected abstract Object doExecute(String var1) throws UnifyException;
}

