/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.web.AbstractPlainController;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ClientResponse;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPlainOutputStreamController
extends AbstractPlainController {
    private String contentType;
    private Map<String, String> metaDataMap;

    public AbstractPlainOutputStreamController() {
        this(MimeType.APPLICATION_OCTETSTREAM);
    }

    public AbstractPlainOutputStreamController(MimeType mimeType) {
        this.contentType = mimeType.template();
    }

    @Override
    public void doProcess(ClientRequest request, ClientResponse response) throws UnifyException {
        this.prepareExecution(request);
        if (this.metaDataMap != null) {
            for (Map.Entry<String, String> entry : this.metaDataMap.entrySet()) {
                response.setMetaData(entry.getKey(), entry.getValue());
            }
        }
        response.setContentType(this.contentType);
        this.doExecute(response.getOutputStream(), request);
    }

    protected String getContentType() {
        return this.contentType;
    }

    protected void setMetaData(String name, String value) {
        if (this.metaDataMap == null) {
            this.metaDataMap = new HashMap<String, String>();
        }
        this.metaDataMap.put(name, value);
    }

    protected void setContentLength(long contentLength) {
        this.setMetaData("Content-Length", String.valueOf(contentLength));
    }

    protected abstract String getResourceName();

    protected abstract boolean isAttachment();

    protected abstract void prepareExecution(ClientRequest var1) throws UnifyException;

    protected abstract void doExecute(OutputStream var1, ClientRequest var2) throws UnifyException;
}

