/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Singleton;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.web.AbstractPlainOutputStreamController;
import com.tcdng.unify.web.ClientRequest;
import java.io.InputStream;
import java.io.OutputStream;

@Singleton(value=false)
public abstract class AbstractPlainResourceController
extends AbstractPlainOutputStreamController {
    private static final String RESOURCE_PARAMETER_NAME = "resource";
    private static final String ATTACHMENT_PARAMETER_NAME = "attachment";
    private String resourceName;
    private boolean attachment;

    public AbstractPlainResourceController() {
    }

    public AbstractPlainResourceController(MimeType mimeType) {
        super(mimeType);
    }

    @Override
    protected void prepareExecution(ClientRequest request) throws UnifyException {
        this.resourceName = request.getParameter(String.class, RESOURCE_PARAMETER_NAME);
        this.attachment = request.getParameter(Boolean.TYPE, ATTACHMENT_PARAMETER_NAME);
        this.setContentDisposition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doExecute(OutputStream outStream, ClientRequest request) throws UnifyException {
        InputStream in = null;
        try {
            in = this.getInputStream();
            IOUtils.writeAll((OutputStream)outStream, (InputStream)in);
        }
        finally {
            IOUtils.close((InputStream)in);
        }
    }

    @Override
    protected final String getResourceName() {
        return this.resourceName;
    }

    @Override
    protected final boolean isAttachment() {
        return this.attachment;
    }

    protected abstract InputStream getInputStream() throws UnifyException;

    private void setContentDisposition() {
        String disposition = "inline;filename=";
        if (this.isAttachment()) {
            disposition = "attachment;filename=";
        }
        disposition = disposition + "\"" + this.resourceName + "\"";
        this.setMetaData("Content-Disposition", disposition);
    }
}

