/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.UnifyError;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.stream.JsonObjectStreamer;
import com.tcdng.unify.core.stream.ObjectStreamer;
import com.tcdng.unify.core.stream.XmlObjectStreamer;
import com.tcdng.unify.core.util.ReflectUtils;
import com.tcdng.unify.web.AbstractController;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ClientResponse;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.ControllerUtil;
import com.tcdng.unify.web.RemoteCallController;
import com.tcdng.unify.web.RemoteCallControllerInfo;
import com.tcdng.unify.web.RemoteCallGate;
import com.tcdng.unify.web.RemoteCallHandler;
import com.tcdng.unify.web.constant.Secured;
import com.tcdng.unify.web.remotecall.RemoteCallBinaryMessageStreamer;
import com.tcdng.unify.web.remotecall.RemoteCallError;
import com.tcdng.unify.web.remotecall.RemoteCallFormat;
import com.tcdng.unify.web.remotecall.RemoteCallParams;
import com.tcdng.unify.web.remotecall.RemoteCallResult;
import com.tcdng.unify.web.remotecall.RemoteCallXmlMessageStreamer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRemoteCallController
extends AbstractController
implements RemoteCallController {
    @Configurable
    private ControllerUtil controllerUtil;
    @Configurable
    private XmlObjectStreamer xmlObjectStreamer;
    @Configurable
    private JsonObjectStreamer jsonObjectStreamer;
    @Configurable
    private RemoteCallBinaryMessageStreamer remoteCallBinaryMessageStreamer;
    @Configurable
    private RemoteCallXmlMessageStreamer remoteCallXmlMessageStreamer;
    private Map<RemoteCallFormat, ObjectStreamer> objectStreamers;

    public AbstractRemoteCallController(Secured secured) {
        super(secured);
    }

    public AbstractRemoteCallController() {
        super(Secured.FALSE);
    }

    public void setControllerUtil(ControllerUtil controllerUtil) {
        this.controllerUtil = controllerUtil;
    }

    public void setXmlObjectStreamer(XmlObjectStreamer xmlObjectStreamer) {
        this.xmlObjectStreamer = xmlObjectStreamer;
    }

    public void setJsonObjectStreamer(JsonObjectStreamer jsonObjectStreamer) {
        this.jsonObjectStreamer = jsonObjectStreamer;
    }

    public void setRemoteCallBinaryMessageStreamer(RemoteCallBinaryMessageStreamer remoteCallBinaryMessageStreamer) {
        this.remoteCallBinaryMessageStreamer = remoteCallBinaryMessageStreamer;
    }

    public void setRemoteCallXmlMessageStreamer(RemoteCallXmlMessageStreamer remoteCallXmlMessageStreamer) {
        this.remoteCallXmlMessageStreamer = remoteCallXmlMessageStreamer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(ClientRequest request, ClientResponse response) throws UnifyException {
        try {
            ControllerPathParts reqPathParts = request.getRequestPathParts().getControllerPathParts();
            RemoteCallFormat remoteCallFormat = (RemoteCallFormat)((Object)request.getParameter("req_rcf"));
            Object reqBody = request.getParameter("req_rcb");
            Object respBody = this.executeRemoteCall(remoteCallFormat, reqPathParts.getControllerPath(), reqBody);
            response.setContentType(remoteCallFormat.mimeType().template());
            if (request.getCharset() != null) {
                response.setCharacterEncoding(request.getCharset().name());
            }
            if (remoteCallFormat.isStringFormat()) {
                response.getWriter().write((String)respBody);
            } else {
                response.getOutputStream().write((byte[])respBody);
            }
        }
        catch (Exception exception) {
        }
        finally {
            response.close();
        }
    }

    @Override
    public void ensureContextResources(ControllerPathParts controllerPathParts) throws UnifyException {
    }

    @Override
    protected void onInitialize() throws UnifyException {
        this.objectStreamers = new HashMap<RemoteCallFormat, ObjectStreamer>();
        this.objectStreamers.put(RemoteCallFormat.JSON, (ObjectStreamer)this.jsonObjectStreamer);
        this.objectStreamers.put(RemoteCallFormat.XML, (ObjectStreamer)this.xmlObjectStreamer);
        this.objectStreamers.put(RemoteCallFormat.TAGGED_BINARYMESSAGE, this.remoteCallBinaryMessageStreamer);
        this.objectStreamers.put(RemoteCallFormat.TAGGED_XMLMESSAGE, this.remoteCallXmlMessageStreamer);
        this.objectStreamers = Collections.unmodifiableMap(this.objectStreamers);
    }

    protected Object executeRemoteCall(RemoteCallFormat remoteCallFormat, String remoteHandler, Object remoteParam) throws UnifyException {
        Object respObj = null;
        String methodCode = null;
        ObjectStreamer streamer = this.objectStreamers.get((Object)remoteCallFormat);
        RemoteCallHandler handler = null;
        try {
            RemoteCallControllerInfo rbbInfo = this.controllerUtil.getRemoteCallControllerInfo(this.getName());
            handler = rbbInfo.getRemoteCallHandler(remoteHandler);
            RemoteCallParams param = null;
            param = remoteCallFormat.isStringFormat() ? (RemoteCallParams)streamer.unmarshal(handler.getParamType(), (String)remoteParam) : (RemoteCallParams)streamer.unmarshal(handler.getParamType(), (InputStream)new ByteArrayInputStream((byte[])remoteParam));
            methodCode = handler.getMethodCode();
            if (handler.isRestricted() && rbbInfo.isRemoteCallGate()) {
                RemoteCallGate gate = (RemoteCallGate)this.getComponent(rbbInfo.getRemoteCallGateName());
                gate.grantPass(param.getClientAppCode(), methodCode);
            }
            RemoteCallResult result = (RemoteCallResult)handler.getMethod().invoke((Object)this, param);
            respObj = streamer.marshal((Object)result);
        }
        catch (Exception e) {
            this.logError(e);
            RemoteCallResult error = null;
            error = handler != null ? (RemoteCallResult)ReflectUtils.newInstance(handler.getReturnType()) : new RemoteCallError();
            error.setMethodCode(methodCode);
            if (e instanceof UnifyException) {
                UnifyError ue = ((UnifyException)((Object)e)).getUnifyError();
                error.setErrorCode(ue.getErrorCode());
                error.setErrorMsg(this.getSessionMessage(ue.getErrorCode(), ue.getErrorParams()));
            } else if (e.getCause() instanceof UnifyException) {
                UnifyError ue = ((UnifyException)e.getCause()).getUnifyError();
                error.setErrorCode(ue.getErrorCode());
                error.setErrorMsg(this.getSessionMessage(ue.getErrorCode(), ue.getErrorParams()));
            } else {
                error.setErrorCode("UW_0008");
                error.setErrorMsg(e.getMessage());
            }
            respObj = streamer.marshal((Object)error);
        }
        return respObj;
    }
}

