/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyComponentConfig;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.web.Controller;
import com.tcdng.unify.web.ControllerFinder;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.ResourceController;
import java.io.File;

@Component(value="application-controllerfinder")
public class ControllerFinderImpl
extends AbstractUnifyComponent
implements ControllerFinder {
    @Override
    public Controller findController(ControllerPathParts controllerPathParts) throws UnifyException {
        File file;
        this.logDebug("Finding controller for path [{0}]...", new Object[]{controllerPathParts.getControllerPath()});
        String controllerName = controllerPathParts.getControllerName();
        UnifyComponentConfig unifyComponentConfig = this.getComponentConfig(Controller.class, controllerName);
        String path = controllerPathParts.getControllerPath();
        if (unifyComponentConfig == null && (file = new File(IOUtils.buildFilename((String)this.getUnifyComponentContext().getWorkingPath(), (String)path))).exists()) {
            ResourceController realPathController = (ResourceController)this.getComponent("/resource/realpath");
            realPathController.setResourceName(path);
            return realPathController;
        }
        if (unifyComponentConfig == null) {
            throw new UnifyException("UC_0009", new Object[]{path});
        }
        Controller controller = (Controller)this.getComponent(controllerName);
        controller.ensureContextResources(controllerPathParts);
        this.logDebug("Controller with name [{0}] found", new Object[]{controllerName});
        return controller;
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }
}

