/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.data.FactoryMap;
import com.tcdng.unify.web.ControllerFinder;
import com.tcdng.unify.web.ControllerUtil;
import com.tcdng.unify.web.PathInfoRepository;
import com.tcdng.unify.web.RemoteCallController;
import com.tcdng.unify.web.RemoteCallControllerInfo;
import com.tcdng.unify.web.RemoteCallHandler;
import com.tcdng.unify.web.annotation.Gateway;
import com.tcdng.unify.web.annotation.RemoteAction;
import com.tcdng.unify.web.remotecall.RemoteCallParams;
import com.tcdng.unify.web.remotecall.RemoteCallResult;
import java.lang.reflect.Method;
import java.util.HashMap;

@Component(value="application-controllerutil")
public class ControllerUtilImpl
extends AbstractUnifyComponent
implements ControllerUtil {
    @Configurable
    private PathInfoRepository pathInfoRepository;
    @Configurable
    private ControllerFinder controllerFinder;
    private FactoryMap<String, RemoteCallControllerInfo> remoteCallControllerInfoMap = new FactoryMap<String, RemoteCallControllerInfo>(){

        protected RemoteCallControllerInfo create(String controllerName, Object ... params) throws Exception {
            return ControllerUtilImpl.this.createRemoteCallControllerInfo(controllerName);
        }
    };

    public void setPathInfoRepository(PathInfoRepository pathInfoRepository) {
        this.pathInfoRepository = pathInfoRepository;
    }

    public void setControllerFinder(ControllerFinder controllerFinder) {
        this.controllerFinder = controllerFinder;
    }

    @Override
    public RemoteCallControllerInfo getRemoteCallControllerInfo(String controllerName) throws UnifyException {
        return (RemoteCallControllerInfo)this.remoteCallControllerInfoMap.get((Object)controllerName);
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    private RemoteCallControllerInfo createRemoteCallControllerInfo(String controllerName) throws UnifyException {
        Method[] methods;
        Class typeClass = this.getComponentType(RemoteCallController.class, controllerName);
        String gateName = null;
        Gateway ga = typeClass.getAnnotation(Gateway.class);
        if (ga != null) {
            gateName = ga.value();
        }
        HashMap<String, RemoteCallHandler> remoteCallHandlerMap = new HashMap<String, RemoteCallHandler>();
        for (Method method : methods = typeClass.getMethods()) {
            RemoteAction goa = method.getAnnotation(RemoteAction.class);
            if (goa == null) continue;
            if (RemoteCallResult.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 1 && RemoteCallParams.class.isAssignableFrom(method.getParameterTypes()[0])) {
                remoteCallHandlerMap.put(controllerName + '/' + method.getName(), new RemoteCallHandler(goa.name(), method, goa.restricted()));
                continue;
            }
            throw new UnifyException("UW_0002", new Object[]{controllerName, method.getName()});
        }
        return new RemoteCallControllerInfo(controllerName, gateName, remoteCallHandlerMap);
    }
}

