/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.AbstractPlainResourceController;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.util.RealPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

@Component(value="/plain/resource/realpath")
public class PlainRealPathResourceController
extends AbstractPlainResourceController {
    private File file;
    private String subfolder;

    public PlainRealPathResourceController() {
    }

    public PlainRealPathResourceController(String subfolder) {
        this.subfolder = subfolder;
    }

    @Override
    protected void prepareExecution(ClientRequest request) throws UnifyException {
        super.prepareExecution(request);
        String resourceName = this.getResourceName();
        if (!StringUtils.isBlank((String)this.subfolder)) {
            resourceName = this.subfolder + resourceName;
        } else {
            RealPathUtils.checkAccessibleRealPath(resourceName);
        }
        this.file = new File(IOUtils.buildFilename((String)this.getUnifyComponentContext().getWorkingPath(), (String)resourceName));
        if (this.file.exists()) {
            this.setContentLength(this.file.length());
        }
    }

    @Override
    protected InputStream getInputStream() throws UnifyException {
        if (this.file != null && this.file.exists()) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                this.throwOperationErrorException(e);
            }
        }
        return null;
    }
}

