/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.TokenUtils;
import com.tcdng.unify.web.ThemeManager;

@Component(value="application-thememanager")
public class ThemeManagerImpl
extends AbstractUnifyComponent
implements ThemeManager {
    private static final String DEFAULT_THEME_PATH = "/web/themes/farko";

    @Override
    public String expandThemeTag(String resouceName) throws UnifyException {
        if (TokenUtils.isThemeTag((String)resouceName)) {
            resouceName = TokenUtils.extractTokenValue((String)resouceName);
            String themePath = null;
            if (this.getSessionContext().isUserLoggedIn()) {
                themePath = this.getSessionContext().getUserToken().getThemePath();
            }
            if (StringUtils.isBlank(themePath)) {
                themePath = (String)this.getContainerSetting(String.class, "application.web.theme", DEFAULT_THEME_PATH);
            }
            if (themePath.endsWith("/")) {
                if (resouceName.startsWith("/")) {
                    return themePath + resouceName.substring("/".length());
                }
                return themePath + resouceName;
            }
            if (resouceName.startsWith("/")) {
                return themePath + resouceName;
            }
            return themePath + "/" + resouceName;
        }
        return resouceName;
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }
}

