/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.discovery;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.SessionContext;
import com.tcdng.unify.core.UnifyComponentConfig;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.web.RemoteCallController;
import com.tcdng.unify.web.annotation.RemoteAction;
import com.tcdng.unify.web.discovery.APIDiscoveryManager;
import com.tcdng.unify.web.discovery.gem.data.APIDiscoveryRemoteCallInfo;
import com.tcdng.unify.web.remotecall.RemoteCallParams;
import com.tcdng.unify.web.remotecall.RemoteCallResult;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@Component(value="application-apidiscoverymanager")
public class APIDiscoveryManagerImpl
extends AbstractUnifyComponent
implements APIDiscoveryManager {
    private Map<String, RemoteCallInfo> remoteCallInfos = new HashMap<String, RemoteCallInfo>();

    @Override
    public APIDiscoveryRemoteCallInfo getRemoteCallInfo(String code) throws UnifyException {
        RemoteCallInfo rci = this.remoteCallInfos.get(code);
        if (rci == null) {
            throw new UnifyException("UW_0006", new Object[]{code});
        }
        SessionContext sessionContext = this.getSessionContext();
        StringBuilder sb = new StringBuilder();
        sb.append(sessionContext.getUriBase()).append(sessionContext.getContextPath());
        if (sessionContext.isWithTenantPath()) {
            sb.append(sessionContext.getTenantPath());
        }
        sb.append(rci.getPath());
        return new APIDiscoveryRemoteCallInfo(rci.getCode(), rci.getDescription(), sb.toString(), rci.isRestricted());
    }

    protected void onInitialize() throws UnifyException {
        this.logDebug("Initializing API detection...", new Object[0]);
        for (UnifyComponentConfig ucc : this.getComponentConfigs(RemoteCallController.class)) {
            String name = ucc.getName();
            Method[] methods = ucc.getType().getMethods();
            this.logDebug("Detecting API methods for [{0}]...", new Object[]{name});
            for (Method method : methods) {
                RemoteAction raa = method.getAnnotation(RemoteAction.class);
                if (raa == null || !raa.discoverable()) continue;
                if (RemoteCallResult.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 1 && RemoteCallParams.class.isAssignableFrom(method.getParameterTypes()[0])) {
                    RemoteCallInfo existRci = this.remoteCallInfos.get(raa.name());
                    if (existRci != null) {
                        throw new UnifyException("UW_0005", new Object[]{raa.name(), name, existRci.getComponentName()});
                    }
                    String path = name + '/' + method.getName();
                    this.logDebug("... method [{0}] detected.", new Object[]{path});
                    this.remoteCallInfos.put(raa.name(), new RemoteCallInfo(name, raa.name(), this.resolveApplicationMessage(raa.description(), new Object[0]), path, raa.restricted()));
                    continue;
                }
                throw new UnifyException("UW_0002", new Object[]{name, method.getName()});
            }
        }
        this.logDebug("API detection completed...", new Object[0]);
    }

    protected void onTerminate() throws UnifyException {
    }

    private class RemoteCallInfo {
        private String componentName;
        private String code;
        private String description;
        private String path;
        private boolean restricted;

        public RemoteCallInfo(String componentName, String code, String description, String path, boolean restricted) {
            this.componentName = componentName;
            this.code = code;
            this.description = description;
            this.path = path;
            this.restricted = restricted;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isRestricted() {
            return this.restricted;
        }
    }
}

