/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.font;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.data.FactoryMap;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.font.FontSymbolManager;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFontSymbolManager
extends AbstractUnifyComponent
implements FontSymbolManager {
    private Map<String, String> nameToHexMap = new HashMap<String, String>();
    private FactoryMap<String, String> unicodeCode;
    private FactoryMap<String, String> htmlHexCode;

    public AbstractFontSymbolManager() {
        this.registerSymbol("naira-sign", "20A6");
        this.registerSymbol("dollar-sign", "0024");
        this.registerSymbol("cent-sign", "00a2");
        this.registerSymbol("pound-sign", "00a3");
        this.registerSymbol("euro-sign", "20AC");
        this.registerSymbol("yen-sign", "00a5");
        this.registerSymbol("rupee-sign", "20A8");
        this.registerSymbol("ruble-sign", "20BD");
        this.registerSymbol("peso-sign", "20B1");
        this.registerSymbol("baht-sign", "0E3F");
        this.registerSymbol("copyright-sign", "00a9");
        this.registerSymbol("registered-sign", "00ae");
        this.registerSymbol("trademark-sign", "2122");
        this.registerSymbol("celsius-sign", "2103");
        this.registerSymbol("fahrenheit-sign", "2109");
        this.registerSymbol("baht-sign", "0E3F");
        this.unicodeCode = new FactoryMap<String, String>(){

            protected String create(String key, Object ... params) throws Exception {
                return "\\u" + (String)AbstractFontSymbolManager.this.nameToHexMap.get(key);
            }
        };
        this.htmlHexCode = new FactoryMap<String, String>(){

            protected String create(String key, Object ... params) throws Exception {
                return "&#x" + (String)AbstractFontSymbolManager.this.nameToHexMap.get(key) + ";";
            }
        };
    }

    @Override
    public String resolveSymbolUnicode(String symbolName) throws UnifyException {
        String hex = this.nameToHexMap.get(symbolName);
        if (hex != null) {
            return (String)this.unicodeCode.get((Object)symbolName);
        }
        return null;
    }

    @Override
    public String resolveSymbolHtmlHexCode(String symbolName) throws UnifyException {
        String hex = this.nameToHexMap.get(symbolName);
        if (hex != null) {
            return (String)this.htmlHexCode.get((Object)symbolName);
        }
        return null;
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    protected boolean registerSymbol(String symbolName, String hex) {
        if (hex != null && hex.matches("[0-9a-fA-F]+")) {
            this.nameToHexMap.put(symbolName, StringUtils.padLeft((String)hex, (char)'0', (int)4));
            return true;
        }
        return false;
    }
}

