/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.http.HttpClient;
import com.tcdng.unify.web.http.HttpClientTextResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Map;

public abstract class AbstractHttpClient
extends AbstractUnifyComponent
implements HttpClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientTextResponse getRemoteTextResource(String url, Map<String, String> parameters) throws UnifyException {
        HttpURLConnection connection = this.getHttpURLConnection(url);
        try {
            String line;
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.writeBytes(this.getParameters(parameters));
            out.flush();
            out.close();
            int responseCode = connection.getResponseCode();
            StringBuilder responseText = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                responseText.append(line);
            }
            in.close();
            HttpClientTextResponse httpClientTextResponse = new HttpClientTextResponse(responseCode, responseText.toString());
            return httpClientTextResponse;
        }
        catch (Exception e) {
            this.throwOperationErrorException(e);
        }
        finally {
            connection.disconnect();
        }
        return null;
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    private String getParameters(Map<String, String> parameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean isAppendSymbol = false;
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            if (isAppendSymbol) {
                sb.append('&');
            } else {
                isAppendSymbol = true;
            }
            sb.append(URLEncoder.encode(param.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
        }
        return sb.toString();
    }

    protected abstract HttpURLConnection getHttpURLConnection(String var1) throws UnifyException;
}

