/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.core.SessionContext;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UserSession;
import com.tcdng.unify.core.system.UserSessionManager;
import com.tcdng.unify.core.util.ApplicationUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.http.HttpUserSession;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractHttpUserSession
implements HttpUserSession {
    private transient UserSessionManager userSessionManager;
    private SessionContext sessionContext;

    public AbstractHttpUserSession(Locale locale, TimeZone timeZone, String sessionId, String uriBase, String contextPath, String tenantPath, String remoteHost, String remoteIpAddress, String remoteUser) {
        if (StringUtils.isBlank((String)sessionId)) {
            sessionId = ApplicationUtils.generateSessionContextId();
        }
        this.sessionContext = new SessionContext(sessionId, locale, timeZone, uriBase, contextPath, tenantPath, remoteHost, remoteIpAddress, remoteUser);
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public String getRemoteAddress() {
        return this.sessionContext.getRemoteAddress();
    }

    public String getRemoteHost() {
        return this.sessionContext.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.sessionContext.getRemoteUser();
    }

    public String getTenantPath() {
        return this.sessionContext.getTenantPath();
    }

    @Override
    public void invalidate() {
        if (this.sessionContext != null) {
            try {
                this.userSessionManager.removeUserSession((UserSession)this);
                this.sessionContext = null;
            }
            catch (UnifyException unifyException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setTransient(UserSessionManager userSessionManager) {
        this.userSessionManager = userSessionManager;
    }
}

