/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.constant.ClientPlatform;
import com.tcdng.unify.web.AbstractClientRequest;
import com.tcdng.unify.web.ClientCookie;
import com.tcdng.unify.web.ClientRequestType;
import com.tcdng.unify.web.RequestPathParts;
import com.tcdng.unify.web.http.HttpRequestMethodType;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;

public class HttpClientRequest
extends AbstractClientRequest {
    private ClientPlatform clientPlatform;
    private HttpRequestMethodType methodType;
    private RequestPathParts requestPathParts;
    private Charset charset;
    private Map<String, Object> parameters;
    private Map<String, ClientCookie> cookies;

    public HttpClientRequest(ClientPlatform clientPlatform, HttpRequestMethodType methodType, RequestPathParts requestPathParts, Charset charset, Map<String, Object> parameters, Map<String, ClientCookie> cookies) {
        this.clientPlatform = clientPlatform;
        this.methodType = methodType;
        this.requestPathParts = requestPathParts;
        this.charset = charset;
        this.parameters = parameters;
        this.cookies = cookies;
    }

    @Override
    public ClientPlatform getClientPlatform() {
        return this.clientPlatform;
    }

    @Override
    public ClientRequestType getType() {
        return this.methodType.clientRequestType();
    }

    @Override
    public RequestPathParts getRequestPathParts() {
        return this.requestPathParts;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    @Override
    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public InputStream getInputStream() throws UnifyException {
        InputStream in = (InputStream)this.parameters.get("req_rcin");
        if (in == null) {
            throw new UnifyException("UW_0009", new Object[0]);
        }
        return in;
    }

    @Override
    public Set<String> getCookieNames() {
        return this.cookies.keySet();
    }

    @Override
    public ClientCookie getCookie(String name) {
        return this.cookies.get(name);
    }
}

