/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UnifyOperationException;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.web.ClientResponse;
import com.tcdng.unify.web.http.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class HttpClientResponse
implements ClientResponse {
    private HttpResponse response;
    private OutputStream outputStream;
    private Writer writer;
    private boolean outUsed;

    public HttpClientResponse(HttpResponse response) {
        response.setStatusOk();
        this.response = response;
    }

    @Override
    public void setMetaData(String key, String value) {
        this.response.setHeader(key, value);
    }

    @Override
    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    @Override
    public void setCharacterEncoding(String charset) {
        this.response.setCharacterEncoding(charset);
    }

    @Override
    public OutputStream getOutputStream() throws UnifyException {
        try {
            if (this.outputStream == null) {
                this.outputStream = this.response.getOutputStream();
                this.outUsed = true;
            }
            return this.outputStream;
        }
        catch (IOException e) {
            throw new UnifyOperationException((Throwable)e, new Object[]{this.getClass().getSimpleName()});
        }
    }

    @Override
    public Writer getWriter() throws UnifyException {
        try {
            if (this.writer == null) {
                this.writer = this.response.getWriter();
                this.outUsed = true;
            }
            return this.writer;
        }
        catch (IOException e) {
            throw new UnifyOperationException((Throwable)e, new Object[]{this.getClass().getSimpleName()});
        }
    }

    @Override
    public void setStatus(int status) {
        this.response.setStatus(status);
    }

    @Override
    public void setStatusOk() {
        this.response.setStatusOk();
    }

    @Override
    public void setStatusForbidden() {
        this.response.setStatusForbidden();
    }

    @Override
    public void setCookie(String name, String val) {
        this.response.setCookie(name, val);
    }

    @Override
    public void setCookie(String name, String val, int maxAge) {
        this.response.setCookie(name, val, maxAge);
    }

    @Override
    public void setCookie(String domain, String path, String name, String val, int maxAge) {
        this.response.setCookie(domain, path, name, val, maxAge);
    }

    @Override
    public void close() {
        IOUtils.close((OutputStream)this.outputStream);
        IOUtils.close((Writer)this.writer);
    }

    @Override
    public boolean isOutUsed() {
        return this.outUsed;
    }
}

