/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UserSession;
import com.tcdng.unify.core.UserToken;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.constant.ClientPlatform;
import com.tcdng.unify.core.data.FactoryMap;
import com.tcdng.unify.core.data.UploadedFile;
import com.tcdng.unify.core.util.CalendarUtils;
import com.tcdng.unify.core.util.ColorUtils;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ClientCookie;
import com.tcdng.unify.web.Controller;
import com.tcdng.unify.web.ControllerFinder;
import com.tcdng.unify.web.PathInfoRepository;
import com.tcdng.unify.web.RequestPathParts;
import com.tcdng.unify.web.TenantPathManager;
import com.tcdng.unify.web.http.AbstractHttpUserSession;
import com.tcdng.unify.web.http.HttpClientRequest;
import com.tcdng.unify.web.http.HttpClientResponse;
import com.tcdng.unify.web.http.HttpPart;
import com.tcdng.unify.web.http.HttpRequest;
import com.tcdng.unify.web.http.HttpRequestHandler;
import com.tcdng.unify.web.http.HttpRequestMethodType;
import com.tcdng.unify.web.http.HttpResponse;
import com.tcdng.unify.web.http.HttpServletModule;
import com.tcdng.unify.web.http.HttpUserSession;
import com.tcdng.unify.web.remotecall.RemoteCallFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component(value="application-httprequesthandler")
public class HttpRequestHandlerImpl
extends AbstractUnifyComponent
implements HttpRequestHandler {
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String DISPOSITION_FILENAME = "filename";
    private static final String DISPOSITION_CREATIONDATE = "creation-date";
    private static final String DISPOSITION_MODIFICATIONDATE = "modification-date";
    private static final int BUFFER_SIZE = 4096;
    @Configurable
    private ControllerFinder controllerFinder;
    @Configurable
    private PathInfoRepository pathInfoRepository;
    @Configurable
    private TenantPathManager tenantPathManager;
    private FactoryMap<String, RequestPathParts> requestPathParts = new FactoryMap<String, RequestPathParts>(){

        protected RequestPathParts create(String resolvedPath, Object ... params) throws Exception {
            int len = resolvedPath.length();
            if (len > 0 && resolvedPath.charAt(len - 1) == '/') {
                resolvedPath = resolvedPath.substring(0, len - 1);
            }
            String controllerPath = resolvedPath;
            String tenantPath = null;
            if (HttpRequestHandlerImpl.this.isTenantPathEnabled) {
                if (StringUtils.isBlank((String)resolvedPath)) {
                    throw new UnifyException("UW_000A", new Object[0]);
                }
                int cIndex = resolvedPath.indexOf(47, 1);
                if (cIndex > 0) {
                    tenantPath = resolvedPath.substring(0, cIndex);
                    controllerPath = resolvedPath.substring(cIndex);
                } else {
                    tenantPath = resolvedPath;
                    controllerPath = null;
                }
                HttpRequestHandlerImpl.this.tenantPathManager.verifyTenantPath(tenantPath);
            }
            if (StringUtils.isBlank((String)controllerPath)) {
                controllerPath = (String)HttpRequestHandlerImpl.this.getContainerSetting(String.class, "application.web.home", "/home");
            }
            return new RequestPathParts(HttpRequestHandlerImpl.this.pathInfoRepository.getControllerPathParts(controllerPath), tenantPath);
        }
    };
    private Set<String> remoteViewerList;
    private boolean isRemoteViewStrict;
    private boolean isTenantPathEnabled;

    public void setControllerFinder(ControllerFinder controllerFinder) {
        this.controllerFinder = controllerFinder;
    }

    public void setPathInfoRepository(PathInfoRepository pathInfoRepository) {
        this.pathInfoRepository = pathInfoRepository;
    }

    public void setTenantPathManager(TenantPathManager tenantPathManager) {
        this.tenantPathManager = tenantPathManager;
    }

    @Override
    public RequestPathParts resolveRequestPath(HttpRequest httpRequest) throws UnifyException {
        String resolvedPath = httpRequest.getPathInfo();
        return (RequestPathParts)this.requestPathParts.get((Object)(resolvedPath == null ? "" : resolvedPath));
    }

    @Override
    public RequestPathParts getRequestPathParts(String requestPath) throws UnifyException {
        return (RequestPathParts)this.requestPathParts.get((Object)requestPath);
    }

    @Override
    public void handleRequest(HttpRequestMethodType methodType, RequestPathParts requestPathParts, HttpRequest httpRequest, HttpResponse httpResponse) throws UnifyException {
        try {
            Charset charset = StandardCharsets.UTF_8;
            if (httpRequest.getCharacterEncoding() != null) {
                charset = Charset.forName(httpRequest.getCharacterEncoding());
            }
            HttpClientRequest clientRequest = new HttpClientRequest(this.detectClientPlatform(httpRequest), methodType, requestPathParts, charset, this.extractRequestParameters(httpRequest, charset), this.extractCookies(httpRequest));
            HttpClientResponse clientResponse = new HttpClientResponse(httpResponse);
            String origin = httpRequest.getHeader("origin");
            String string = origin = origin != null ? origin : httpRequest.getHeader("Origin");
            if (!StringUtils.isBlank((String)origin)) {
                if (this.remoteViewerList.isEmpty() || this.remoteViewerList.contains(origin)) {
                    httpResponse.setHeader("Access-Control-Allow-Origin", origin);
                    httpResponse.setHeader("Access-Control-Allow-Methods", "POST, GET, PUT, OPTIONS");
                    httpResponse.setHeader("Access-Control-Allow-Headers", "Content-Type");
                    httpResponse.setHeader("Access-Control-Max-Age", "600");
                } else if (this.isRemoteViewStrict) {
                    clientResponse.setStatusForbidden();
                    return;
                }
            }
            Controller controller = this.controllerFinder.findController(clientRequest.getRequestPathParts().getControllerPathParts());
            controller.process(clientRequest, clientResponse);
        }
        catch (UnifyException ue) {
            this.logError((Exception)((Object)ue));
            throw ue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSession getUserSession(HttpServletModule httpModule, HttpRequest httpRequest, RequestPathParts reqPathParts) throws UnifyException {
        HttpUserSession userSession = null;
        if (reqPathParts.isSessionless()) {
            httpRequest.invalidateSession();
            userSession = this.createHttpUserSession(httpModule, httpRequest, reqPathParts, null);
        } else if (StringUtils.isNotBlank((String)httpRequest.getParameter("req_rv"))) {
            httpRequest.invalidateSession();
            String sessionId = httpRequest.getParameter("req_rsi");
            userSession = (AbstractHttpUserSession)httpModule.getUserSessionManager().getUserSession(sessionId);
            if (userSession == null) {
                userSession = this.createHttpUserSession(httpModule, httpRequest, reqPathParts, sessionId);
                httpModule.getUserSessionManager().addUserSession((UserSession)userSession);
                String userLoginId = httpRequest.getParameter("req_uid");
                String userName = httpRequest.getParameter("req_unm");
                String roleCode = httpRequest.getParameter("req_rcd");
                String branchCode = httpRequest.getParameter("req_bcd");
                String zoneCode = httpRequest.getParameter("req_zcd");
                String tenantCode = httpRequest.getParameter("req_tnc");
                String colorScheme = ColorUtils.getConformingColorSchemeCode((String)httpRequest.getParameter("req_csm"));
                boolean globalAccess = Boolean.valueOf(httpRequest.getParameter("req_gac"));
                UserToken userToken = UserToken.newBuilder().userLoginId(userLoginId).userName(userName).ipAddress(userSession.getRemoteAddress()).branchCode(branchCode).zoneCode(zoneCode).tenantCode(tenantCode).colorScheme(colorScheme).globalAccess(globalAccess).allowMultipleLogin(true).remote(true).build();
                userToken.setRoleCode(roleCode);
                userSession.getSessionContext().setUserToken(userToken);
            }
        } else {
            userSession = (HttpUserSession)httpRequest.getSessionAttribute("USER_SESSION");
            if (httpModule.isTenantPathEnabled() && userSession != null && !DataUtils.equals((Object)reqPathParts.getTenantPath(), (Object)userSession.getTenantPath())) {
                httpRequest.removeSessionAttribute("USER_SESSION");
                userSession.invalidate();
                userSession = null;
            }
            if (userSession == null) {
                Object object = httpRequest.getSessionSychObject();
                synchronized (object) {
                    userSession = (HttpUserSession)httpRequest.getSessionAttribute("USER_SESSION");
                    if (userSession == null) {
                        userSession = this.createHttpUserSession(httpModule, httpRequest, reqPathParts, null);
                        httpRequest.setSessionAttribute("USER_SESSION", userSession);
                    }
                }
            }
        }
        userSession.setTransient(httpModule.getUserSessionManager());
        return userSession;
    }

    private HttpUserSession createHttpUserSession(HttpServletModule httpModule, HttpRequest httpRequest, RequestPathParts reqPathParts, String sessionId) throws UnifyException {
        String remoteIpAddress = httpRequest.getHeader("X-FORWARDED-FOR");
        if (remoteIpAddress == null || remoteIpAddress.trim().isEmpty() || "unknown".equalsIgnoreCase(remoteIpAddress)) {
            remoteIpAddress = httpRequest.getHeader("Proxy-Client-IP");
        }
        if (remoteIpAddress == null || remoteIpAddress.trim().isEmpty() || "unknown".equalsIgnoreCase(remoteIpAddress)) {
            remoteIpAddress = httpRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (remoteIpAddress == null || remoteIpAddress.trim().isEmpty() || "unknown".equalsIgnoreCase(remoteIpAddress)) {
            remoteIpAddress = httpRequest.getRemoteAddr();
        }
        StringBuilder uriBase = new StringBuilder();
        uriBase.append(httpRequest.getScheme()).append("://").append(httpRequest.getServerName());
        if (!("http".equals(httpRequest.getScheme()) && httpRequest.getServerPort() == 80 || "https".equals(httpRequest.getScheme()) && httpRequest.getServerPort() == 443)) {
            uriBase.append(":").append(httpRequest.getServerPort());
        }
        HttpUserSession userSession = httpRequest.createHttpUserSession(httpModule.getApplicationLocale(), httpModule.getApplicationTimeZone(), sessionId, uriBase.toString(), httpModule.getContextPath(), reqPathParts.getTenantPath(), remoteIpAddress);
        userSession.setTransient(httpModule.getUserSessionManager());
        return userSession;
    }

    protected void onInitialize() throws UnifyException {
        this.isRemoteViewStrict = (Boolean)this.getContainerSetting(Boolean.TYPE, "application.web.remote.viewers.strict", false);
        this.isTenantPathEnabled = (Boolean)this.getContainerSetting(Boolean.TYPE, "application.web.tenantpath.enabled", false);
        List viewersList = (List)DataUtils.convert(ArrayList.class, String.class, (Object)this.getContainerSetting(Object.class, "application.web.remote.viewers"));
        this.remoteViewerList = !DataUtils.isBlank((Collection)viewersList) ? new HashSet<String>(viewersList) : Collections.emptySet();
    }

    protected void onTerminate() throws UnifyException {
    }

    private ClientPlatform detectClientPlatform(HttpRequest httpRequest) {
        ClientPlatform platform = ClientPlatform.DEFAULT;
        String userAgent = httpRequest.getHeader("User-Agent");
        if (userAgent != null && userAgent.indexOf("Mobile") >= 0) {
            platform = ClientPlatform.MOBILE;
        }
        return platform;
    }

    private Map<String, ClientCookie> extractCookies(HttpRequest httpRequest) {
        List<ClientCookie> cookieList = httpRequest.getCookies();
        if (!DataUtils.isBlank(cookieList)) {
            HashMap<String, ClientCookie> cookies = new HashMap<String, ClientCookie>();
            for (ClientCookie clientCookie : cookieList) {
                cookies.put(clientCookie.getName(), clientCookie);
            }
            return cookies;
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> extractRequestParameters(HttpRequest httpRequest, Charset charset) throws UnifyException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String contentType = httpRequest.getContentType() == null ? null : httpRequest.getContentType().toLowerCase();
        RemoteCallFormat remoteCallFormat = RemoteCallFormat.fromContentType(httpRequest.getHeader("Unify-Web-Message-Type"), contentType);
        if (remoteCallFormat != null) {
            result.put("req_rcf", (Object)remoteCallFormat);
            try {
                switch (remoteCallFormat) {
                    case OCTETSTREAM: {
                        result.put("req_rcin", httpRequest.getInputStream());
                        break;
                    }
                    case TAGGED_BINARYMESSAGE: {
                        result.put("req_rcb", IOUtils.readAll((InputStream)httpRequest.getInputStream()));
                        break;
                    }
                    case JSON: 
                    case TAGGED_XMLMESSAGE: 
                    case XML: {
                        result.put("req_rcb", IOUtils.readAll((BufferedReader)httpRequest.getReader()));
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.throwOperationErrorException(e);
            }
        } else {
            boolean isFormData;
            boolean bl = isFormData = contentType != null && contentType.indexOf("multipart/form-data") >= 0;
            if (isFormData) {
                this.processParts(result, httpRequest);
            } else {
                boolean chkMorsic = true;
                Map<String, String[]> httpRequestParamMap = httpRequest.getParameterMap();
                for (Map.Entry<String, String[]> entry : httpRequestParamMap.entrySet()) {
                    String key = entry.getKey();
                    if (chkMorsic && "morsic".equals(key)) {
                        chkMorsic = false;
                        continue;
                    }
                    String[] values = entry.getValue();
                    if (values.length == 1) {
                        if (!values[0].isEmpty()) {
                            result.put(key, values[0]);
                            continue;
                        }
                        result.put(key, null);
                        continue;
                    }
                    result.put(key, values);
                }
            }
        }
        return result;
    }

    private void processParts(Map<String, Object> requestParameterMap, HttpRequest httpRequest) throws UnifyException {
        this.logDebug("Processing multi-part request parameters [{0}]", new Object[]{requestParameterMap.keySet()});
        try {
            List list;
            HashMap<String, ArrayList<String>> stringMap = new HashMap<String, ArrayList<String>>();
            HashMap<String, ArrayList<UploadedFile>> uploadedFileMap = new HashMap<String, ArrayList<UploadedFile>>();
            char[] buffer = new char[4096];
            boolean chkMorsic = true;
            for (HttpPart httpPart : httpRequest.getParts()) {
                String name = httpPart.getName();
                if (chkMorsic && "morsic".equals(name)) {
                    chkMorsic = false;
                    continue;
                }
                ContentDisposition contentDisposition = this.getContentDisposition(httpPart);
                if (contentDisposition.isFileName()) {
                    UploadedFile frmFile = new UploadedFile(contentDisposition.getFileName(), contentDisposition.getCreationDate(), contentDisposition.getModificationDate(), IOUtils.readAll((InputStream)httpPart.getInputStream()));
                    ArrayList<UploadedFile> list2 = (ArrayList<UploadedFile>)uploadedFileMap.get(name);
                    if (list2 == null) {
                        list2 = new ArrayList<UploadedFile>();
                        uploadedFileMap.put(name, list2);
                    }
                    list2.add(frmFile);
                    continue;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(httpPart.getInputStream()));
                StringBuilder sb = new StringBuilder();
                int length = 0;
                while ((length = reader.read(buffer)) > 0) {
                    sb.append(buffer, 0, length);
                }
                ArrayList<String> list3 = (ArrayList<String>)stringMap.get(name);
                if (list3 == null) {
                    list3 = new ArrayList<String>();
                    stringMap.put(name, list3);
                }
                list3.add(sb.toString());
            }
            for (Map.Entry entry : stringMap.entrySet()) {
                list = (List)entry.getValue();
                if (list.size() == 1) {
                    if (!((String)list.get(0)).isEmpty()) {
                        requestParameterMap.put((String)entry.getKey(), list.get(0));
                        continue;
                    }
                    requestParameterMap.put((String)entry.getKey(), null);
                    continue;
                }
                requestParameterMap.put((String)entry.getKey(), DataUtils.toArray(String.class, (List)list));
            }
            for (Map.Entry entry : uploadedFileMap.entrySet()) {
                list = (List)entry.getValue();
                requestParameterMap.put((String)entry.getKey(), DataUtils.toArray(UploadedFile.class, (List)list));
            }
        }
        catch (UnifyException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationErrorException(e);
        }
        this.logDebug("Multi-part request processing completed", new Object[0]);
    }

    private ContentDisposition getContentDisposition(HttpPart part) throws UnifyException {
        String fileName = null;
        Date creationDate = null;
        Date modificationDate = null;
        for (String disposition : part.getHeader(CONTENT_DISPOSITION).split(";")) {
            if (disposition.trim().startsWith(DISPOSITION_FILENAME)) {
                fileName = disposition.substring(disposition.indexOf(61) + 1).trim().replace("\"", "");
                continue;
            }
            if (disposition.trim().startsWith(DISPOSITION_CREATIONDATE)) {
                creationDate = CalendarUtils.parseRfc822Date((String)disposition.substring(disposition.indexOf(61) + 1).trim());
                continue;
            }
            if (!disposition.trim().startsWith(DISPOSITION_MODIFICATIONDATE)) continue;
            modificationDate = CalendarUtils.parseRfc822Date((String)disposition.substring(disposition.indexOf(61) + 1).trim());
        }
        return new ContentDisposition(fileName, creationDate, modificationDate);
    }

    private class ContentDisposition {
        private String fileName;
        private Date creationDate;
        private Date modificationDate;

        public ContentDisposition(String fileName, Date creationDate, Date modificationDate) {
            this.fileName = fileName;
            this.creationDate = creationDate;
            this.modificationDate = modificationDate;
        }

        public String getFileName() {
            return this.fileName;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public Date getModificationDate() {
            return this.modificationDate;
        }

        public boolean isFileName() {
            return this.fileName != null;
        }
    }
}

