/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.core.RequestContextManager;
import com.tcdng.unify.core.UnifyContainer;
import com.tcdng.unify.core.UnifyContainerConfig;
import com.tcdng.unify.core.UnifyContainerEnvironment;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.system.UserSessionManager;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.TypeRepository;
import com.tcdng.unify.core.util.UnifyConfigUtils;
import com.tcdng.unify.web.RequestPathParts;
import com.tcdng.unify.web.UnifyWebInterface;
import com.tcdng.unify.web.http.HttpRequest;
import com.tcdng.unify.web.http.HttpRequestHandler;
import com.tcdng.unify.web.http.HttpRequestMethodType;
import com.tcdng.unify.web.http.HttpResponse;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import java.util.TimeZone;

public class HttpServletModule {
    private UnifyContainer unifyContainer;
    private UnifyWebInterface webInterface;
    private RequestContextManager requestContextManager;
    private HttpRequestHandler httpRequestHandler;
    private UserSessionManager userSessionManager;
    private Locale applicationLocale;
    private TimeZone applicationTimeZone;
    private String contextPath;
    private boolean isTenantPathEnabled;
    private boolean embedded;

    public HttpServletModule() {
        this(false);
    }

    public HttpServletModule(boolean embedded) {
        this.embedded = embedded;
    }

    public void init(String contextPath, String workingFolder, String configFilename, TypeRepository tr) throws Exception {
        if (!this.embedded) {
            if (StringUtils.isBlank((String)configFilename)) {
                configFilename = IOUtils.buildFilename((String)workingFolder, (String)"conf/unify.xml");
            }
            FileInputStream configInputStream = null;
            try {
                this.contextPath = contextPath;
                UnifyContainerEnvironment uce = new UnifyContainerEnvironment(tr, workingFolder);
                UnifyContainerConfig.Builder uccb = UnifyContainerConfig.newBuilder();
                UnifyConfigUtils.readConfigFromTypeRepository((UnifyContainerConfig.Builder)uccb, (TypeRepository)tr, (String[])new String[0]);
                uccb.deploymentMode(true);
                configInputStream = new FileInputStream(IOUtils.fileInstance((String)configFilename, null));
                UnifyConfigUtils.readConfigFromXml((UnifyContainerConfig.Builder)uccb, (InputStream)configInputStream, (String)workingFolder);
                uccb.setPropertyIfBlank("application.web.home", (Object)"/home");
                UnifyContainerConfig ucc = uccb.build();
                this.unifyContainer = new UnifyContainer();
                this.unifyContainer.startup(uce, ucc);
                this.applicationLocale = this.unifyContainer.getApplicationLocale();
                this.applicationTimeZone = this.unifyContainer.getApplicationTimeZone();
                this.requestContextManager = (RequestContextManager)this.unifyContainer.getComponent("application-requestcontextmanager");
                this.httpRequestHandler = (HttpRequestHandler)this.unifyContainer.getComponent("application-httprequesthandler");
                this.userSessionManager = (UserSessionManager)this.unifyContainer.getComponent("application-usersessionmanager");
                this.isTenantPathEnabled = (Boolean)DataUtils.convert(Boolean.TYPE, (Object)this.unifyContainer.getSetting("application.web.tenantpath.enabled"));
            }
            catch (UnifyException e) {
                try {
                    e.printStackTrace();
                    if (this.unifyContainer != null && this.unifyContainer.isStarted()) {
                        this.unifyContainer.shutdown();
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.close(configInputStream);
                    throw throwable;
                }
            }
            IOUtils.close((InputStream)configInputStream);
        }
    }

    public void init(Locale applicationLocale, TimeZone applicationTimeZone, UnifyWebInterface webInterface, RequestContextManager requestContextManager, HttpRequestHandler applicationController, UserSessionManager userSessionManager, boolean isTenantPathEnabled) {
        this.applicationLocale = applicationLocale;
        this.applicationTimeZone = applicationTimeZone;
        this.webInterface = webInterface;
        this.requestContextManager = requestContextManager;
        this.httpRequestHandler = applicationController;
        this.userSessionManager = userSessionManager;
        this.isTenantPathEnabled = isTenantPathEnabled;
        this.contextPath = webInterface.getContextPath();
    }

    public void destroy() {
        if (this.unifyContainer != null && this.unifyContainer.isStarted()) {
            this.unifyContainer.shutdown();
        }
    }

    public UnifyWebInterface getWebInterface() {
        return this.webInterface;
    }

    public RequestContextManager getRequestContextManager() {
        return this.requestContextManager;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public UserSessionManager getUserSessionManager() {
        return this.userSessionManager;
    }

    public Locale getApplicationLocale() {
        return this.applicationLocale;
    }

    public TimeZone getApplicationTimeZone() {
        return this.applicationTimeZone;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isTenantPathEnabled() {
        return this.isTenantPathEnabled;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpRequestMethodType type, HttpRequest httpRequest, HttpResponse httpResponse) throws UnifyException {
        if (!this.embedded || this.webInterface.isServicingRequests()) {
            try {
                HttpRequestHandler httpRequestHandler = this.getHttpRequestHandler();
                RequestPathParts reqPathParts = httpRequestHandler.resolveRequestPath(httpRequest);
                this.requestContextManager.loadRequestContext(httpRequestHandler.getUserSession(this, httpRequest, reqPathParts), httpRequest.getServletPath());
                httpRequestHandler.handleRequest(type, reqPathParts, httpRequest, httpResponse);
            }
            finally {
                try {
                    this.userSessionManager.updateCurrentSessionLastAccessTime();
                }
                catch (Exception exception) {}
                this.requestContextManager.unloadRequestContext();
            }
        }
    }
}

