/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.remotecall;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.constant.PrintFormat;
import com.tcdng.unify.core.data.TaggedBinaryMessage;
import com.tcdng.unify.core.stream.AbstractObjectStreamer;
import com.tcdng.unify.web.remotecall.PullBinaryMessageParams;
import com.tcdng.unify.web.remotecall.PullBinaryMessageResult;
import com.tcdng.unify.web.remotecall.PushBinaryMessageParams;
import com.tcdng.unify.web.remotecall.PushBinaryMessageResult;
import com.tcdng.unify.web.remotecall.RemoteCallBinaryMessageStreamer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

@Component(value="rc-binarymessagestreamer")
public class RemoteCallBinaryMessageStreamerImpl
extends AbstractObjectStreamer
implements RemoteCallBinaryMessageStreamer {
    public <T> T unmarshal(Class<T> type, InputStream inputStream, Charset charset) throws UnifyException {
        try {
            ObjectInputStream ois = new ObjectInputStream(inputStream);
            if (PushBinaryMessageParams.class.equals(type)) {
                String clientAppCode = (String)ois.readObject();
                String methodCode = (String)ois.readObject();
                String destination = (String)ois.readObject();
                return (T)new PushBinaryMessageParams(methodCode, clientAppCode, destination, this.readTaggedBinaryObject(ois));
            }
            if (PushBinaryMessageResult.class.equals(type)) {
                String methodCode = (String)ois.readObject();
                String errorCode = (String)ois.readObject();
                String errorMsg = (String)ois.readObject();
                return (T)new PushBinaryMessageResult(methodCode, errorCode, errorMsg);
            }
            if (PullBinaryMessageParams.class.equals(type)) {
                String clientAppCode = (String)ois.readObject();
                String methodCode = (String)ois.readObject();
                String source = (String)ois.readObject();
                return (T)new PullBinaryMessageParams(methodCode, clientAppCode, source);
            }
            if (PullBinaryMessageResult.class.equals(type)) {
                String methodCode = (String)ois.readObject();
                String errorCode = (String)ois.readObject();
                String errorMsg = (String)ois.readObject();
                return (T)new PullBinaryMessageResult(methodCode, errorCode, errorMsg, this.readTaggedBinaryObject(ois));
            }
            this.throwOperationErrorException(new RuntimeException("Unsupported stream object type - " + type));
        }
        catch (Exception e) {
            this.throwOperationErrorException(e);
        }
        return null;
    }

    public <T> T unmarshal(Class<T> type, Reader reader) throws UnifyException {
        this.throwUnsupportedOperationException();
        return null;
    }

    public <T> T unmarshal(Class<T> type, String string) throws UnifyException {
        this.throwUnsupportedOperationException();
        return null;
    }

    public void marshal(Object object, OutputStream outputStream, Charset charset, PrintFormat printFormat) throws UnifyException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(outputStream);
            if (PushBinaryMessageParams.class.equals(object.getClass())) {
                PushBinaryMessageParams tmParams = (PushBinaryMessageParams)object;
                oos.writeObject(tmParams.getClientAppCode());
                oos.writeObject(tmParams.getMethodCode());
                oos.writeObject(tmParams.getDestination());
                this.writeTaggedBinaryObject(oos, tmParams.getTaggedMessage());
            } else if (PushBinaryMessageResult.class.equals(object.getClass())) {
                PushBinaryMessageResult rma = (PushBinaryMessageResult)object;
                oos.writeObject(rma.getMethodCode());
                oos.writeObject(rma.getErrorCode());
                oos.writeObject(rma.getErrorMsg());
            } else if (PullBinaryMessageParams.class.equals(object.getClass())) {
                PullBinaryMessageParams tmParams = (PullBinaryMessageParams)object;
                oos.writeObject(tmParams.getClientAppCode());
                oos.writeObject(tmParams.getMethodCode());
                oos.writeObject(tmParams.getSource());
            } else if (PullBinaryMessageResult.class.equals(object.getClass())) {
                PullBinaryMessageResult rma = (PullBinaryMessageResult)object;
                oos.writeObject(rma.getMethodCode());
                oos.writeObject(rma.getErrorCode());
                oos.writeObject(rma.getErrorMsg());
                this.writeTaggedBinaryObject(oos, rma.getTaggedMessage());
            } else {
                this.throwOperationErrorException(new RuntimeException("Unsupported stream object type - " + object.getClass()));
            }
            oos.flush();
        }
        catch (IOException e) {
            this.throwOperationErrorException(e);
        }
    }

    public void marshal(Object object, Writer writer, PrintFormat printFormat) throws UnifyException {
        this.throwUnsupportedOperationException();
    }

    public byte[] marshal(Object object, PrintFormat printFormat) throws UnifyException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.marshal(object, baos);
        return baos.toByteArray();
    }

    private TaggedBinaryMessage readTaggedBinaryObject(ObjectInputStream ois) throws Exception {
        String tag = (String)ois.readObject();
        String branchCode = (String)ois.readObject();
        String departmentCode = (String)ois.readObject();
        String consumer = (String)ois.readObject();
        int length = ois.readInt();
        byte[] message = null;
        if (length > 0) {
            message = new byte[length];
            ois.readFully(message);
        }
        return new TaggedBinaryMessage(tag, branchCode, departmentCode, consumer, message);
    }

    private void writeTaggedBinaryObject(ObjectOutputStream oos, TaggedBinaryMessage tm) throws IOException {
        oos.writeObject(tm.getTag());
        oos.writeObject(tm.getBranchCode());
        oos.writeObject(tm.getDepartmentCode());
        oos.writeObject(tm.getConsumer());
        byte[] message = tm.getMessage();
        int length = 0;
        if (message != null) {
            length = message.length;
        }
        oos.writeInt(length);
        if (length > 0) {
            oos.write(message);
        }
    }
}

