/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.remotecall;

import com.tcdng.unify.convert.constants.EnumConst;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.util.EnumUtils;

public enum RemoteCallFormat implements EnumConst
{
    JSON("JSON", MimeType.APPLICATION_JSON),
    XML("XML", MimeType.APPLICATION_XML),
    OCTETSTREAM("OCTETSTRM", MimeType.APPLICATION_OCTETSTREAM),
    TAGGED_XMLMESSAGE("TAG_XML", MimeType.APPLICATION_XML),
    TAGGED_BINARYMESSAGE("TAG_OCTET", MimeType.APPLICATION_OCTETSTREAM);

    private String code;
    private MimeType mimeType;

    private RemoteCallFormat(String code, MimeType mimeType) {
        this.code = code;
        this.mimeType = mimeType;
    }

    public MimeType mimeType() {
        return this.mimeType;
    }

    public String code() {
        return this.code;
    }

    public String defaultCode() {
        return RemoteCallFormat.JSON.code;
    }

    public boolean isStringFormat() {
        return JSON.equals((Object)this) || XML.equals((Object)this) || TAGGED_XMLMESSAGE.equals((Object)this);
    }

    public boolean isTagged() {
        return TAGGED_BINARYMESSAGE.equals((Object)this) || TAGGED_XMLMESSAGE.equals((Object)this);
    }

    public static RemoteCallFormat fromCode(String code) {
        return (RemoteCallFormat)EnumUtils.fromCode(RemoteCallFormat.class, (String)code);
    }

    public static RemoteCallFormat fromName(String name) {
        return (RemoteCallFormat)EnumUtils.fromName(RemoteCallFormat.class, (String)name);
    }

    public static RemoteCallFormat fromContentType(String header, String contentType) {
        if (contentType != null) {
            if (contentType.startsWith(RemoteCallFormat.JSON.mimeType.template())) {
                return JSON;
            }
            if (contentType.startsWith(RemoteCallFormat.XML.mimeType.template())) {
                if ("tagged".equals(header)) {
                    return TAGGED_XMLMESSAGE;
                }
                return XML;
            }
            if (contentType.equals(RemoteCallFormat.OCTETSTREAM.mimeType.template())) {
                if ("tagged".equals(header)) {
                    return TAGGED_BINARYMESSAGE;
                }
                return OCTETSTREAM;
            }
        }
        return null;
    }
}

