/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.remotecall;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.data.FactoryMaps;
import com.tcdng.unify.core.stream.JsonObjectStreamer;
import com.tcdng.unify.core.stream.ObjectStreamer;
import com.tcdng.unify.core.stream.XmlObjectStreamer;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.core.util.NetworkUtils;
import com.tcdng.unify.web.discovery.gem.data.DiscoverRemoteCallParams;
import com.tcdng.unify.web.discovery.gem.data.DiscoverRemoteCallResult;
import com.tcdng.unify.web.remotecall.PushBinaryMessageParams;
import com.tcdng.unify.web.remotecall.PushBinaryMessageResult;
import com.tcdng.unify.web.remotecall.PushXmlMessageParams;
import com.tcdng.unify.web.remotecall.PushXmlMessageResult;
import com.tcdng.unify.web.remotecall.RemoteCallBinaryMessageStreamer;
import com.tcdng.unify.web.remotecall.RemoteCallFormat;
import com.tcdng.unify.web.remotecall.RemoteCallParams;
import com.tcdng.unify.web.remotecall.RemoteCallResult;
import com.tcdng.unify.web.remotecall.RemoteCallXmlMessageStreamer;
import com.tcdng.unify.web.remotecall.WebClient;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Component(value="application-webclient")
public class WebClientImpl
extends AbstractUnifyComponent
implements WebClient {
    @Configurable
    private XmlObjectStreamer xmlObjectStreamer;
    @Configurable
    private JsonObjectStreamer jsonObjectStreamer;
    @Configurable
    private RemoteCallBinaryMessageStreamer remoteCallBinaryMessageStreamer;
    @Configurable
    private RemoteCallXmlMessageStreamer remoteCallXmlMessageStreamer;
    private Map<RemoteCallFormat, ObjectStreamer> objectStreamers;
    private FactoryMaps<String, String, RemoteCallSetup> preferences = new FactoryMaps<String, String, RemoteCallSetup>(){

        protected RemoteCallSetup createObject(String remoteAppURL, String methodCode, Object ... params) throws Exception {
            return new RemoteCallSetup((RemoteCallFormat)((Object)params[1]), (Charset)params[2], (String)params[0]);
        }
    };

    public void setXmlObjectStreamer(XmlObjectStreamer xmlObjectStreamer) {
        this.xmlObjectStreamer = xmlObjectStreamer;
    }

    public void setJsonObjectStreamer(JsonObjectStreamer jsonObjectStreamer) {
        this.jsonObjectStreamer = jsonObjectStreamer;
    }

    public void setRemoteCallBinaryMessageStreamer(RemoteCallBinaryMessageStreamer remoteCallBinaryMessageStreamer) {
        this.remoteCallBinaryMessageStreamer = remoteCallBinaryMessageStreamer;
    }

    public void setRemoteCallXmlMessageStreamer(RemoteCallXmlMessageStreamer remoteCallXmlMessageStreamer) {
        this.remoteCallXmlMessageStreamer = remoteCallXmlMessageStreamer;
    }

    public void setObjectStreamers(Map<RemoteCallFormat, ObjectStreamer> objectStreamers) {
        this.objectStreamers = objectStreamers;
    }

    public void setPreferences(FactoryMaps<String, String, RemoteCallSetup> preferences) {
        this.preferences = preferences;
    }

    @Override
    public void setupRemoteCall(String remoteAppURL, String methodCode) throws UnifyException {
        this.setupRemoteCall(remoteAppURL, methodCode, RemoteCallFormat.JSON, StandardCharsets.UTF_8);
    }

    @Override
    public void setupBinaryMessagingRemoteCall(String remoteAppURL, String methodCode) throws UnifyException {
        this.setupRemoteCall(remoteAppURL, methodCode, RemoteCallFormat.TAGGED_BINARYMESSAGE, null);
    }

    @Override
    public void setupXmlMessagingRemoteCall(String remoteAppURL, String methodCode) throws UnifyException {
        this.setupRemoteCall(remoteAppURL, methodCode, RemoteCallFormat.TAGGED_XMLMESSAGE, StandardCharsets.UTF_8);
    }

    @Override
    public void setupRemoteCall(String remoteAppURL, String methodCode, RemoteCallFormat format, Charset charset) throws UnifyException {
        this.logDebug("Setting up remote call with code = [{0}], remoteAppURL = [{1}]...", new Object[]{methodCode, remoteAppURL});
        if (this.preferences.isKey((Object)remoteAppURL, (Object)methodCode)) {
            throw new UnifyException("UW_0003", new Object[]{remoteAppURL, methodCode});
        }
        this.logDebug("Discovering remote call method with code [{0}] for remote application [{1}]...", new Object[]{methodCode, remoteAppURL});
        String discoveryURL = this.getDiscoveryURL(remoteAppURL);
        if (!this.isRemoteCallSetup(discoveryURL, "apidiscovery-001")) {
            this.preferences.get((Object)discoveryURL, (Object)"apidiscovery-001", new Object[]{discoveryURL, RemoteCallFormat.JSON, StandardCharsets.UTF_8});
        }
        DiscoverRemoteCallResult result = this.remoteCall(DiscoverRemoteCallResult.class, discoveryURL, new DiscoverRemoteCallParams(methodCode));
        this.checkError(result);
        this.preferences.get((Object)remoteAppURL, (Object)methodCode, new Object[]{result.getRemoteCallInfo().getUrl(), format, charset});
        this.logDebug("...remote call setup completed.", new Object[0]);
    }

    @Override
    public void clearAllRemoteCallSetup(String remoteAppURL) throws UnifyException {
        this.preferences.remove((Object)remoteAppURL);
    }

    @Override
    public void clearRemoteCallSetup(String remoteAppURL, String methodCode) throws UnifyException {
        this.preferences.remove((Object)remoteAppURL, (Object)methodCode);
    }

    @Override
    public boolean isRemoteCallSetup(String remoteAppURL, String methodCode) throws UnifyException {
        return this.preferences.isKey((Object)remoteAppURL, (Object)methodCode);
    }

    @Override
    public PushBinaryMessageResult sendBinaryMessage(String remoteAppURL, PushBinaryMessageParams params) throws UnifyException {
        return this.remoteCall(PushBinaryMessageResult.class, remoteAppURL, params);
    }

    @Override
    public PushXmlMessageResult sendXmlMessage(String remoteAppURL, PushXmlMessageParams params) throws UnifyException {
        return this.remoteCall(PushXmlMessageResult.class, remoteAppURL, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends RemoteCallResult> T remoteCall(Class<T> resultType, String remoteAppURL, RemoteCallParams param) throws UnifyException {
        RemoteCallResult result = null;
        if (!this.preferences.isKey((Object)remoteAppURL, (Object)param.getMethodCode())) {
            throw new UnifyException("UW_0004", new Object[]{remoteAppURL, param.getMethodCode()});
        }
        RemoteCallSetup remoteCallSetup = (RemoteCallSetup)this.preferences.get((Object)remoteAppURL, (Object)param.getMethodCode(), new Object[0]);
        param.setClientAppCode(this.getApplicationCode());
        OutputStream out = null;
        InputStream in = null;
        try {
            Charset charset = remoteCallSetup.getCharset();
            ObjectStreamer streamer = this.objectStreamers.get((Object)remoteCallSetup.getFormat());
            RemoteCallFormat format = remoteCallSetup.getFormat();
            HttpURLConnection conn = (HttpURLConnection)new URL(remoteCallSetup.getTargetURL()).openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Type", format.mimeType().template());
            if (charset != null) {
                conn.setRequestProperty("Accept-Charset", charset.name());
            }
            if (format.isTagged()) {
                conn.setRequestProperty("Unify-Web-Message-Type", "tagged");
            }
            conn.connect();
            out = conn.getOutputStream();
            streamer.marshal((Object)param, out, charset);
            out.flush();
            out.close();
            in = conn.getInputStream();
            result = (RemoteCallResult)streamer.unmarshal(resultType, in, charset);
            this.checkError(result);
            IOUtils.close((OutputStream)out);
        }
        catch (UnifyException e) {
            throw e;
            catch (Exception e2) {
                this.throwOperationErrorException(e2);
                return (T)result;
            }
        }
        IOUtils.close((InputStream)in);
        return (T)result;
        finally {
            IOUtils.close(out);
            IOUtils.close(in);
        }
    }

    protected void onInitialize() throws UnifyException {
        this.objectStreamers = new HashMap<RemoteCallFormat, ObjectStreamer>();
        this.objectStreamers.put(RemoteCallFormat.JSON, (ObjectStreamer)this.jsonObjectStreamer);
        this.objectStreamers.put(RemoteCallFormat.XML, (ObjectStreamer)this.xmlObjectStreamer);
        this.objectStreamers.put(RemoteCallFormat.TAGGED_BINARYMESSAGE, this.remoteCallBinaryMessageStreamer);
        this.objectStreamers.put(RemoteCallFormat.TAGGED_XMLMESSAGE, this.remoteCallXmlMessageStreamer);
        this.objectStreamers = Collections.unmodifiableMap(this.objectStreamers);
    }

    protected void onTerminate() throws UnifyException {
    }

    private String getDiscoveryURL(String remoteAppURL) throws UnifyException {
        return NetworkUtils.constructURL((String)remoteAppURL, (String)"/apidiscovery/discoverRemoteCall");
    }

    private void checkError(RemoteCallResult result) throws UnifyException {
        if (result.isError()) {
            throw new UnifyException("UW_0007", new Object[]{result.getErrorCode(), result.getErrorMsg()});
        }
    }

    private class RemoteCallSetup {
        private RemoteCallFormat format;
        private Charset charset;
        private String targetURL;

        public RemoteCallSetup(RemoteCallFormat format, Charset charset, String targetURL) {
            this.format = format;
            this.charset = charset;
            this.targetURL = targetURL;
        }

        public RemoteCallFormat getFormat() {
            return this.format;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public String getTargetURL() {
            return this.targetURL;
        }
    }
}

