/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.util;

import com.tcdng.unify.core.data.LargeStringWriter;

public final class HtmlUtils {
    private HtmlUtils() {
    }

    public static String getStringWithHtmlEscape(String string) {
        StringBuilder sb = new StringBuilder();
        HtmlUtils.writeStringWithHtmlEscape(sb, string);
        return sb.toString();
    }

    public static void writeStringWithHtmlEscape(StringBuilder sb, String string) {
        if (string == null) {
            sb.append(string);
            return;
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            HtmlUtils.writeChar(sb, string.charAt(i));
        }
    }

    public static void writeChar(StringBuilder sb, char ch) {
        switch (ch) {
            case '<': {
                sb.append("&lt;");
                break;
            }
            case '>': {
                sb.append("&gt;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '\"': {
                sb.append("&quot;");
                break;
            }
            case '\'': {
                sb.append("&apos;");
                break;
            }
            default: {
                sb.append(ch);
            }
        }
    }

    public static void writeChar(LargeStringWriter lsw, char ch) {
        switch (ch) {
            case '<': {
                lsw.append("&lt;");
                break;
            }
            case '>': {
                lsw.append("&gt;");
                break;
            }
            case '&': {
                lsw.append("&amp;");
                break;
            }
            case '\"': {
                lsw.append("&quot;");
                break;
            }
            case '\'': {
                lsw.append("&apos;");
                break;
            }
            default: {
                lsw.append(ch);
            }
        }
    }

    public static String extractStyleAttribute(String style, String attributeName) {
        int stopIndex;
        int startIndex;
        if (style != null && !style.isEmpty() && (startIndex = style.indexOf(attributeName)) >= 0 && (stopIndex = style.indexOf(59, startIndex)) > 0) {
            return style.substring(startIndex, ++stopIndex);
        }
        return "";
    }
}

