/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.AbstractTDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.GroupTree;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ArrayDigest
extends AbstractTDigest {
    private final int pageSize;
    private List<Page> data = new ArrayList<Page>();
    private int totalWeight = 0;
    private int centroidCount = 0;
    private double compression = 100.0;
    public static final int VERBOSE_ENCODING = 1;
    public static final int SMALL_ENCODING = 2;
    public static final int VERBOSE_ARRAY_DIGEST = 3;
    public static final int SMALL_ARRAY_DIGEST = 4;

    public ArrayDigest(int pageSize, double compression) {
        if (pageSize <= 3) {
            throw new IllegalArgumentException("Must have page size of 4 or more");
        }
        this.pageSize = pageSize;
        this.compression = compression;
    }

    @Override
    public void add(double x, int w) {
        Index start = this.floor(x);
        if (start == null) {
            start = this.ceiling(x);
        }
        if (start == null) {
            this.addRaw(x, w);
        } else {
            Index neighbor;
            double z;
            Iterable<Index> neighbors = this.inclusiveTail(start);
            double minDistance = Double.MAX_VALUE;
            int lastNeighbor = 0;
            int i = this.headCount(start);
            Iterator<Index> i$ = neighbors.iterator();
            while (i$.hasNext() && (z = Math.abs(this.mean(neighbor = i$.next()) - x)) <= minDistance) {
                minDistance = z;
                lastNeighbor = i++;
            }
            Index closest = null;
            int sum = this.headSum(start);
            i = this.headCount(start);
            double n = 0.0;
            for (Index neighbor2 : neighbors) {
                if (i > lastNeighbor) break;
                double z2 = Math.abs(this.mean(neighbor2) - x);
                double q = ((double)sum + (double)this.count(neighbor2) / 2.0) / (double)this.totalWeight;
                double k = (double)(4 * this.totalWeight) * q * (1.0 - q) / this.compression;
                if (z2 == minDistance && (double)(this.count(neighbor2) + w) <= k) {
                    n += 1.0;
                    if (this.gen.nextDouble() < 1.0 / n) {
                        closest = neighbor2;
                    }
                }
                sum += this.count(neighbor2);
                ++i;
            }
            if (closest == null) {
                this.addRaw(x, w);
            } else if (n == 1.0) {
                Page p = this.data.get(closest.page);
                int n2 = closest.subPage;
                p.counts[n2] = p.counts[n2] + w;
                p.totalCount += w;
                int n3 = closest.subPage;
                p.centroids[n3] = p.centroids[n3] + (x - p.centroids[closest.subPage]) / (double)p.counts[closest.subPage];
                if (p.history != null && p.history.get(closest.subPage) != null) {
                    p.history.get(closest.subPage).add(x);
                }
                this.totalWeight += w;
            } else {
                int weight = this.count(closest) + w;
                double center = this.mean(closest);
                center += (x - center) / (double)weight;
                if (this.mean(this.increment(closest, -1)) <= center && this.mean(this.increment(closest, 1)) >= center) {
                    Page p = this.data.get(closest.page);
                    p.counts[closest.subPage] = weight;
                    p.centroids[closest.subPage] = center;
                    p.totalCount += w;
                    this.totalWeight += w;
                    if (p.history != null && p.history.get(closest.subPage) != null) {
                        p.history.get(closest.subPage).add(x);
                    }
                } else {
                    this.delete(closest);
                    List<Double> history = this.history(closest);
                    if (history != null) {
                        history.add(x);
                    }
                    this.addRaw(center, weight, history);
                }
            }
            if ((double)this.centroidCount > 100.0 * this.compression) {
                this.compress();
            }
        }
    }

    public int headSum(Index limit) {
        int r = 0;
        for (int i = 0; limit != null && i < limit.page; ++i) {
            r += this.data.get((int)i).totalCount;
        }
        if (limit != null && limit.page < this.data.size()) {
            for (int j = 0; j < limit.subPage; ++j) {
                r += this.data.get((int)limit.page).counts[j];
            }
        }
        return r;
    }

    private int headCount(Index limit) {
        int r = 0;
        for (int i = 0; i < limit.page; ++i) {
            r += this.data.get((int)i).active;
        }
        if (limit.page < this.data.size()) {
            for (int j = 0; j < limit.subPage; ++j) {
                ++r;
            }
        }
        return r;
    }

    public double mean(Index index) {
        return this.data.get((int)index.page).centroids[index.subPage];
    }

    public int count(Index index) {
        return this.data.get((int)index.page).counts[index.subPage];
    }

    @Override
    public void compress() {
        ArrayDigest reduced = new ArrayDigest(this.pageSize, this.compression);
        if (this.recordAllData) {
            reduced.recordAllData();
        }
        ArrayList<Index> tmp = new ArrayList<Index>();
        Iterator<Index> ix = this.iterator(0, 0);
        while (ix.hasNext()) {
            tmp.add(ix.next());
        }
        Collections.shuffle(tmp, this.gen);
        for (Index index : tmp) {
            reduced.add(this.mean(index), this.count(index));
        }
        this.data = reduced.data;
        this.centroidCount = reduced.centroidCount;
    }

    @Override
    public void compress(GroupTree other) {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public int size() {
        return this.totalWeight;
    }

    @Override
    public double cdf(double x) {
        double left;
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (this.size() == 1) {
            return x < this.data.get((int)0).centroids[0] ? 0.0 : 1.0;
        }
        double r = 0.0;
        Iterator<Index> it = this.iterator(0, 0);
        Index a = it.next();
        Index b = it.next();
        double right = left = (b.mean() - a.mean()) / 2.0;
        while (it.hasNext()) {
            if (x < a.mean() + right) {
                return (r + (double)a.count() * AbstractTDigest.interpolate(x, a.mean() - left, a.mean() + right)) / (double)this.totalWeight;
            }
            r += (double)a.count();
            a = b;
            b = it.next();
            left = right;
            right = (b.mean() - a.mean()) / 2.0;
        }
        left = right;
        a = b;
        if (x < a.mean() + right) {
            return (r + (double)a.count() * AbstractTDigest.interpolate(x, a.mean() - left, a.mean() + right)) / (double)this.totalWeight;
        }
        return 1.0;
    }

    @Override
    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        if (this.centroidCount() == 0) {
            return Double.NaN;
        }
        if (this.centroidCount() == 1) {
            return this.data.get((int)0).centroids[0];
        }
        double index = q * (double)(this.size() - 1);
        double previousMean = Double.NaN;
        double previousIndex = 0.0;
        long total = 0L;
        Iterator<Index> it = this.iterator(0, 0);
        while (true) {
            Index next;
            double nextIndex;
            if ((nextIndex = (double)total + ((double)(next = it.next()).count() - 1.0) / 2.0) >= index) {
                if (Double.isNaN(previousMean)) {
                    if (nextIndex == previousIndex) {
                        return next.mean();
                    }
                    Index next2 = it.next();
                    double nextIndex2 = (double)(total + (long)next.count()) + ((double)next2.count() - 1.0) / 2.0;
                    previousMean = (nextIndex2 * next.mean() - nextIndex * next2.mean()) / (nextIndex2 - nextIndex);
                }
                return ArrayDigest.quantile(previousIndex, index, nextIndex, previousMean, next.mean());
            }
            if (!it.hasNext()) {
                double nextIndex2 = this.size() - 1;
                double nextMean2 = (next.mean() * (nextIndex2 - previousIndex) - previousMean * (nextIndex2 - nextIndex)) / (nextIndex - previousIndex);
                return ArrayDigest.quantile(nextIndex, index, nextIndex2, next.mean(), nextMean2);
            }
            total += (long)next.count();
            previousMean = next.mean();
            previousIndex = nextIndex;
        }
    }

    @Override
    public int centroidCount() {
        return this.centroidCount;
    }

    @Override
    public Iterable<? extends Centroid> centroids() {
        ArrayList<Centroid> r = new ArrayList<Centroid>();
        Iterator<Index> ix = this.iterator(0, 0);
        while (ix.hasNext()) {
            Index index = ix.next();
            Page current = this.data.get(index.page);
            Centroid centroid = new Centroid(current.centroids[index.subPage], current.counts[index.subPage]);
            if (current.history != null) {
                for (double x : current.history.get(index.subPage)) {
                    centroid.insertData(x);
                }
            }
            r.add(centroid);
        }
        return r;
    }

    public Iterator<Index> allAfter(double x) {
        if (this.data.size() == 0) {
            return this.iterator(0, 0);
        }
        for (int i = 1; i < this.data.size(); ++i) {
            if (!(this.data.get((int)i).centroids[0] >= x)) continue;
            Page previous = this.data.get(i - 1);
            for (int j = 0; j < previous.active; ++j) {
                if (!(previous.centroids[j] > x)) continue;
                return this.iterator(i - 1, j);
            }
            return this.iterator(i, 0);
        }
        Page last = this.data.get(this.data.size() - 1);
        for (int j = 0; j < last.active; ++j) {
            if (!(last.centroids[j] > x)) continue;
            return this.iterator(this.data.size() - 1, j);
        }
        return this.iterator(this.data.size(), 0);
    }

    public Index floor(double x) {
        Index r;
        Iterator<Index> rx = this.allBefore(x);
        if (!rx.hasNext()) {
            return null;
        }
        Index z = r = rx.next();
        while (rx.hasNext() && this.mean(z) == x) {
            r = z;
            z = rx.next();
        }
        return r;
    }

    public Index ceiling(double x) {
        Iterator<Index> r = this.allAfter(x);
        return r.hasNext() ? r.next() : null;
    }

    public Iterator<Index> allBefore(double x) {
        if (this.data.size() == 0) {
            return this.iterator(0, 0);
        }
        for (int i = 1; i < this.data.size(); ++i) {
            if (!(this.data.get((int)i).centroids[0] > x)) continue;
            Page previous = this.data.get(i - 1);
            for (int j = 0; j < previous.active; ++j) {
                if (!(previous.centroids[j] > x)) continue;
                return this.reverse(i - 1, j - 1);
            }
            return this.reverse(i, -1);
        }
        Page last = this.data.get(this.data.size() - 1);
        for (int j = 0; j < last.active; ++j) {
            if (!(last.centroids[j] > x)) continue;
            return this.reverse(this.data.size() - 1, j - 1);
        }
        return this.reverse(this.data.size(), -1);
    }

    public Index increment(Index x, int delta) {
        int j;
        int i = x.page;
        for (j = x.subPage + delta; i < this.data.size() && j >= this.data.get((int)i).active; j -= this.data.get((int)i).active, ++i) {
        }
        while (i > 0 && j < 0) {
            j += this.data.get((int)(--i)).active;
        }
        return new Index(i, j);
    }

    @Override
    public double compression() {
        return this.compression;
    }

    @Override
    public int byteSize() {
        return 20 + this.centroidCount * 12;
    }

    @Override
    public int smallByteSize() {
        int bound = this.byteSize();
        ByteBuffer buf = ByteBuffer.allocate(bound);
        this.asSmallBytes(buf);
        return buf.position();
    }

    @Override
    public void asBytes(ByteBuffer buf) {
        int i;
        buf.putInt(3);
        buf.putDouble(this.compression());
        buf.putInt(this.pageSize);
        buf.putInt(this.centroidCount);
        for (Page page : this.data) {
            for (i = 0; i < page.active; ++i) {
                buf.putDouble(page.centroids[i]);
            }
        }
        for (Page page : this.data) {
            for (i = 0; i < page.active; ++i) {
                buf.putInt(page.counts[i]);
            }
        }
    }

    @Override
    public void asSmallBytes(ByteBuffer buf) {
        int i;
        buf.putInt(4);
        buf.putDouble(this.compression());
        buf.putInt(this.pageSize);
        buf.putInt(this.centroidCount);
        double x = 0.0;
        for (Page page : this.data) {
            for (i = 0; i < page.active; ++i) {
                double mean = page.centroids[i];
                double delta = mean - x;
                x = mean;
                buf.putFloat((float)delta);
            }
        }
        for (Page page : this.data) {
            for (i = 0; i < page.active; ++i) {
                int n = page.counts[i];
                ArrayDigest.encode(buf, n);
            }
        }
    }

    public static ArrayDigest fromBytes(ByteBuffer buf) {
        int encoding = buf.getInt();
        if (encoding == 1 || encoding == 3) {
            int i;
            double compression = buf.getDouble();
            int pageSize = 32;
            if (encoding == 3) {
                pageSize = buf.getInt();
            }
            ArrayDigest r = new ArrayDigest(pageSize, compression);
            int n = buf.getInt();
            double[] means = new double[n];
            for (i = 0; i < n; ++i) {
                means[i] = buf.getDouble();
            }
            for (i = 0; i < n; ++i) {
                r.add(means[i], buf.getInt());
            }
            return r;
        }
        if (encoding == 2 || encoding == 4) {
            int i;
            double compression = buf.getDouble();
            int pageSize = 32;
            if (encoding == 4) {
                pageSize = buf.getInt();
            }
            ArrayDigest r = new ArrayDigest(pageSize, compression);
            int n = buf.getInt();
            double[] means = new double[n];
            double x = 0.0;
            for (i = 0; i < n; ++i) {
                double delta = buf.getFloat();
                means[i] = x += delta;
            }
            for (i = 0; i < n; ++i) {
                int z = ArrayDigest.decode(buf);
                r.add(means[i], z);
            }
            return r;
        }
        throw new IllegalStateException("Invalid format for serialized histogram");
    }

    private List<Double> history(Index index) {
        List<List<Double>> h = this.data.get((int)index.page).history;
        return h == null ? null : h.get(index.subPage);
    }

    private void delete(Index index) {
        this.totalWeight -= this.count(index);
        --this.centroidCount;
        this.data.get(index.page).delete(index.subPage);
    }

    private Iterable<Index> inclusiveTail(final Index start) {
        return new Iterable<Index>(){

            @Override
            public Iterator<Index> iterator() {
                return ArrayDigest.this.iterator(start.page, start.subPage);
            }
        };
    }

    void addRaw(double x, int w) {
        ArrayList<Double> tmp = new ArrayList<Double>();
        tmp.add(x);
        this.addRaw(x, w, this.recordAllData ? tmp : null);
    }

    void addRaw(double x, int w, List<Double> history) {
        if (this.centroidCount == 0) {
            Page page = new Page(this.pageSize, this.recordAllData);
            page.add(x, w, history);
            this.totalWeight += w;
            ++this.centroidCount;
            this.data.add(page);
        } else {
            for (int i = 1; i < this.data.size(); ++i) {
                if (!(this.data.get((int)i).centroids[0] > x)) continue;
                Page newPage = this.data.get(i - 1).add(x, w, history);
                this.totalWeight += w;
                ++this.centroidCount;
                if (newPage != null) {
                    this.data.add(i, newPage);
                }
                return;
            }
            Page newPage = this.data.get(this.data.size() - 1).add(x, w, history);
            this.totalWeight += w;
            ++this.centroidCount;
            if (newPage != null) {
                this.data.add(this.data.size(), newPage);
            }
        }
    }

    @Override
    void add(double x, int w, Centroid base) {
        this.addRaw(x, w, base.data());
    }

    private Iterator<Index> iterator(final int startPage, final int startSubPage) {
        return new Iterator<Index>(){
            int page;
            int subPage;
            Index end;
            Index next;
            {
                this.page = startPage;
                this.subPage = startSubPage;
                this.end = new Index(-1, -1);
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.computeNext();
                }
                return this.next != this.end;
            }

            @Override
            public Index next() {
                if (this.hasNext()) {
                    Index r = this.next;
                    this.next = null;
                    return r;
                }
                throw new NoSuchElementException("Can't iterate past end of data");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Default operation");
            }

            protected Index computeNext() {
                if (this.page >= ArrayDigest.this.data.size()) {
                    return this.end;
                }
                Page current = (Page)ArrayDigest.this.data.get(this.page);
                if (this.subPage >= current.active) {
                    this.subPage = 0;
                    ++this.page;
                    return this.computeNext();
                }
                Index r = new Index(this.page, this.subPage);
                ++this.subPage;
                return r;
            }
        };
    }

    private Iterator<Index> reverse(final int startPage, final int startSubPage) {
        return new Iterator<Index>(){
            int page;
            int subPage;
            Index end;
            Index next;
            {
                this.page = startPage;
                this.subPage = startSubPage;
                this.end = new Index(-1, -1);
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.computeNext();
                }
                return this.next != this.end;
            }

            @Override
            public Index next() {
                if (this.hasNext()) {
                    Index r = this.next;
                    this.next = null;
                    return r;
                }
                throw new NoSuchElementException("Can't reverse iterate before beginning of data");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Default operation");
            }

            protected Index computeNext() {
                if (this.page < 0) {
                    return this.end;
                }
                if (this.subPage < 0) {
                    --this.page;
                    if (this.page >= 0) {
                        this.subPage = ((Page)((ArrayDigest)ArrayDigest.this).data.get((int)this.page)).active - 1;
                    }
                    return this.computeNext();
                }
                Index r = new Index(this.page, this.subPage);
                --this.subPage;
                return r;
            }
        };
    }

    private static class Page {
        private final boolean recordAllData;
        private final int pageSize;
        int totalCount;
        int active;
        double[] centroids;
        int[] counts;
        List<List<Double>> history;

        private Page(int pageSize, boolean recordAllData) {
            this.pageSize = pageSize;
            this.recordAllData = recordAllData;
            this.centroids = new double[this.pageSize];
            this.counts = new int[this.pageSize];
            this.history = this.recordAllData ? new ArrayList() : null;
        }

        public Page add(double x, int w, List<Double> history) {
            for (int i = 0; i < this.active; ++i) {
                if (!(this.centroids[i] >= x)) continue;
                if (this.active >= this.pageSize) {
                    Page newPage = this.split();
                    if (i < this.pageSize / 2) {
                        this.addAt(i, x, w, history);
                    } else {
                        newPage.addAt(i - this.pageSize / 2, x, w, history);
                    }
                    return newPage;
                }
                this.addAt(i, x, w, history);
                return null;
            }
            if (this.active >= this.pageSize) {
                Page newPage = this.split();
                newPage.addAt(this.pageSize / 2, x, w, history);
                return newPage;
            }
            this.addAt(this.active, x, w, history);
            return null;
        }

        private void addAt(int i, double x, int w, List<Double> history) {
            if (i < this.active) {
                System.arraycopy(this.centroids, i, this.centroids, i + 1, this.active - i);
                System.arraycopy(this.counts, i, this.counts, i + 1, this.active - i);
                if (this.history != null) {
                    this.history.add(i, history);
                }
                this.centroids[i] = x;
                this.counts[i] = w;
            } else {
                this.centroids[this.active] = x;
                this.counts[this.active] = w;
                if (this.history != null) {
                    this.history.add(history);
                }
            }
            ++this.active;
            this.totalCount += w;
        }

        private Page split() {
            Page newPage = new Page(this.pageSize, this.recordAllData);
            System.arraycopy(this.centroids, 16, newPage.centroids, 0, this.pageSize / 2);
            System.arraycopy(this.counts, 16, newPage.counts, 0, this.pageSize / 2);
            if (this.history != null) {
                newPage.history = new ArrayList<List<Double>>();
                newPage.history.addAll(this.history.subList(this.pageSize / 2, this.pageSize));
                ArrayList<List<Double>> tmp = new ArrayList<List<Double>>();
                tmp.addAll(this.history.subList(0, this.pageSize / 2));
                this.history = tmp;
            }
            this.active = 16;
            newPage.active = 16;
            newPage.totalCount = this.totalCount;
            this.totalCount = 0;
            for (int i = 0; i < 16; ++i) {
                this.totalCount += this.counts[i];
                newPage.totalCount -= this.counts[i];
            }
            return newPage;
        }

        public void delete(int i) {
            int w = this.counts[i];
            if (i != this.active - 1) {
                System.arraycopy(this.centroids, i + 1, this.centroids, i, this.active - i - 1);
                System.arraycopy(this.counts, i + 1, this.counts, i, this.active - i - 1);
                if (this.history != null) {
                    this.history.remove(i);
                }
            }
            --this.active;
            this.totalCount -= w;
        }
    }

    class Index {
        final int page;
        final int subPage;

        private Index(int page, int subPage) {
            this.page = page;
            this.subPage = subPage;
        }

        double mean() {
            return ((Page)((ArrayDigest)ArrayDigest.this).data.get((int)this.page)).centroids[this.subPage];
        }

        int count() {
            return ((Page)((ArrayDigest)ArrayDigest.this).data.get((int)this.page)).counts[this.subPage];
        }
    }
}

