/*
 * Decompiled with CFR 0.152.
 */
package com.teambytes.cloudwatch.appenders.log4j;

import com.amazonaws.services.logs.AWSLogsAsyncClient;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u00015\u0011!c\u00117pk\u0012<\u0018\r^2i\u0003B\u0004XM\u001c3fe*\u00111\u0001B\u0001\u0006Y><GG\u001b\u0006\u0003\u000b\u0019\t\u0011\"\u00199qK:$WM]:\u000b\u0005\u001dA\u0011AC2m_V$w/\u0019;dQ*\u0011\u0011BC\u0001\ni\u0016\fWNY=uKNT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"aD\u000b\u000e\u0003AQ!aA\t\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0005\u0003-A\u0011\u0001#\u00119qK:$WM]*lK2,Go\u001c8\t\u000ba\u0001A\u0011A\r\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u0005\u0011\u0001bB\u000f\u0001\u0005\u0004%IAH\u0001\nC^\u001c8\t\\5f]R,\u0012a\b\t\u0003A\u001dj\u0011!\t\u0006\u0003E\r\nA\u0001\\8hg*\u0011A%J\u0001\tg\u0016\u0014h/[2fg*\u0011aEC\u0001\nC6\f'p\u001c8boNL!\u0001K\u0011\u0003%\u0005;6\u000bT8hg\u0006\u001b\u0018P\\2DY&,g\u000e\u001e\u0005\u0007U\u0001\u0001\u000b\u0011B\u0010\u0002\u0015\u0005<8o\u00117jK:$\b\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\u0005=lW#\u0001\u0018\u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0005M\"\u0014a\u00026bG.\u001cxN\u001c\u0006\u0003k)\t\u0011BZ1ti\u0016\u0014\b0\u001c7\n\u0005]\u0002$\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\bBB\u001d\u0001A\u0003%a&A\u0002p[\u0002Bqa\u000f\u0001A\u0002\u0013\u0005A(\u0001\u0007m_\u001e<%o\\;q\u001d\u0006lW-F\u0001>!\tqDI\u0004\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"A\u0011\u001dA\u0005\u00011A\u0005\u0002%\u000b\u0001\u0003\\8h\u000fJ|W\u000f\u001d(b[\u0016|F%Z9\u0015\u0005)k\u0005CA L\u0013\ta\u0005I\u0001\u0003V]&$\bb\u0002(H\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\n\u0004B\u0002)\u0001A\u0003&Q(A\u0007m_\u001e<%o\\;q\u001d\u0006lW\r\t\u0015\u0003\u001fJ\u0003\"a\u0015,\u000e\u0003QS!!\u0016!\u0002\u000b\t,\u0017M\\:\n\u0005]#&\u0001\u0004\"fC:\u0004&o\u001c9feRL\b\"B-\u0001\t\u0003Q\u0016aD4fi2{wm\u0012:pkBt\u0015-\\3\u0015\u0003uBQ\u0001\u0018\u0001\u0005\u0002u\u000bqb]3u\u0019><wI]8va:\u000bW.\u001a\u000b\u0003\u0015zCqAT.\u0002\u0002\u0003\u0007Q\bC\u0004a\u0001\u0001\u0007I\u0011\u0001\u001f\u0002\u001b1|wm\u0015;sK\u0006lg*Y7f\u0011\u001d\u0011\u0007\u00011A\u0005\u0002\r\f\u0011\u0003\\8h'R\u0014X-Y7OC6,w\fJ3r)\tQE\rC\u0004OC\u0006\u0005\t\u0019A\u001f\t\r\u0019\u0004\u0001\u0015)\u0003>\u00039awnZ*ue\u0016\fWNT1nK\u0002B#!\u001a*\t\u000b%\u0004A\u0011\u0001.\u0002!\u001d,G\u000fT8h'R\u0014X-Y7OC6,\u0007\"B6\u0001\t\u0003a\u0017\u0001E:fi2{wm\u0015;sK\u0006lg*Y7f)\tQU\u000eC\u0004OU\u0006\u0005\t\u0019A\u001f\t\u000f=\u0004!\u0019!C\u0005a\u0006I\u0011m\u0019;jm\u0006$X\rZ\u000b\u0002cB\u0011!o_\u0007\u0002g*\u0011A/^\u0001\u0007CR|W.[2\u000b\u0005Y<\u0018AC2p]\u000e,(O]3oi*\u0011\u00010_\u0001\u0005kRLGNC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q\u001c(!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004\u007f\u0001\u0001\u0006I!]\u0001\u000bC\u000e$\u0018N^1uK\u0012\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0003Ea\u0017m\u001d;TKF,XM\\2f)>\\WM\\\u000b\u0003\u0003\u000b\u0001BA]A\u0004{%\u0019\u0011\u0011B:\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016D\u0001\"!\u0004\u0001A\u0003%\u0011QA\u0001\u0013Y\u0006\u001cHoU3rk\u0016t7-\u001a+pW\u0016t\u0007\u0005C\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\u001f\u0005\u001cG/\u001b<bi\u0016|\u0005\u000f^5p]N$\u0012A\u0013\u0005\b\u0003/\u0001A\u0011AA\r\u0003\u0019\t\u0007\u000f]3oIR\u0019!*a\u0007\t\u0011\u0005u\u0011Q\u0003a\u0001\u0003?\tQ!\u001a<f]R\u0004B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003K\u0001\u0012aA:qS&!\u0011\u0011FA\u0012\u00051aunZ4j]\u001e,e/\u001a8u\u0011\u001d\ti\u0003\u0001C\u0005\u0003_\t\u0011b]3oI\u00163XM\u001c;\u0015\u0007)\u000b\t\u0004C\u0004\u00024\u0005-\u0002\u0019A\u001f\u0002\u000f5,7o]1hK\"9\u0011q\u0007\u0001\u0005\n\u0005e\u0012\u0001\u00057pO\u001eLgnZ#wK:$('T1q)\u0011\tY$a\u0017\u0011\u0011\u0005u\u0012qIA&\u0003+j!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\nS6lW\u000f^1cY\u0016T1!!\u0012A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0013\nyDA\u0002NCB\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#J\u0018\u0001\u00027b]\u001eL1!RA(!\ry\u0014qK\u0005\u0004\u00033\u0002%aA!os\"A\u0011QDA\u001b\u0001\u0004\ty\u0002C\u0004\u0002`\u0001!\t!!\u0019\u0002\u001dI,\u0017/^5sKNd\u0015-_8viR\u0011\u00111\r\t\u0004\u007f\u0005\u0015\u0014bAA4\u0001\n9!i\\8mK\u0006t\u0007bBA6\u0001\u0011\u0005\u00111C\u0001\u0006G2|7/\u001a")
public class CloudwatchAppender
extends AppenderSkeleton {
    private final AWSLogsAsyncClient awsClient = new AWSLogsAsyncClient();
    private final ObjectMapper om;
    private String logGroupName;
    private String logStreamName;
    private final AtomicBoolean activated;
    private final AtomicReference<String> lastSequenceToken;

    private AWSLogsAsyncClient awsClient() {
        return this.awsClient;
    }

    private ObjectMapper om() {
        return this.om;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public void logGroupName_$eq(String x$1) {
        this.logGroupName = x$1;
    }

    public void setLogGroupName(String x$1) {
        this.logGroupName = x$1;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public void logStreamName_$eq(String x$1) {
        this.logStreamName = x$1;
    }

    public void setLogStreamName(String x$1) {
        this.logStreamName = x$1;
    }

    private AtomicBoolean activated() {
        return this.activated;
    }

    private AtomicReference<String> lastSequenceToken() {
        return this.lastSequenceToken;
    }

    public void activateOptions() {
        if (this.getLayout() == null) {
            Predef$.MODULE$.println((Object)"Layout was not defined, will only log the message, no stack traces or custom layout");
        }
        CreateLogGroupRequest createLogGroupRequest = new CreateLogGroupRequest(this.logGroupName());
        try {
            this.awsClient().createLogGroup(createLogGroupRequest);
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log group '", "' already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logGroupName()})));
        }
        CreateLogStreamRequest createLogStreamRequest = new CreateLogStreamRequest(this.logGroupName(), this.logStreamName());
        try {
            this.awsClient().createLogStream(createLogStreamRequest);
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log stream '", "' in group '", "' already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logStreamName(), this.logGroupName()})));
        }
        try {
            this.sendEvent("Getting the next expected sequenceToken for CloudwatchAppender");
        }
        catch (InvalidSequenceTokenException invalidSequenceTokenException) {
            this.lastSequenceToken().set(invalidSequenceTokenException.getExpectedSequenceToken());
        }
        super.activateOptions();
        this.activated().set(true);
    }

    public void append(LoggingEvent event) {
        if (!this.activated().get()) {
            this.activateOptions();
        }
        try {
            this.sendEvent(this.om().writeValueAsString(this.loggingEvent2Map(event)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sendEvent(String message) {
        Seq logEvents = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputLogEvent[]{new InputLogEvent().withTimestamp(Predef$.MODULE$.long2Long(new Date().getTime())).withMessage(message)}));
        PutLogEventsRequest putLogEventsRequest = new PutLogEventsRequest(this.logGroupName(), this.logStreamName(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(logEvents).asJava());
        putLogEventsRequest.setSequenceToken(this.lastSequenceToken().get());
        PutLogEventsResult result = this.awsClient().putLogEvents(putLogEventsRequest);
        this.lastSequenceToken().set(result.getNextSequenceToken());
    }

    private Map<String, Object> loggingEvent2Map(LoggingEvent event) {
        String formattedEvent = this.layout.format(event);
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threadName"), (Object)event.getThreadName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"level"), (Object)event.getLevel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), event.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"formattedMessage"), (Object)formattedEvent), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"loggerName"), (Object)event.getLoggerName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeStamp"), (Object)BoxesRunTime.boxToLong((long)event.getTimeStamp()))}));
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
    }

    public String getLogGroupName() {
        return this.logGroupName();
    }

    public String getLogStreamName() {
        return this.logStreamName();
    }

    /*
     * WARNING - void declaration
     */
    public CloudwatchAppender() {
        void var1_1;
        ObjectMapper omap = new ObjectMapper();
        omap.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.om = var1_1;
        this.logGroupName = null;
        this.logStreamName = null;
        this.activated = new AtomicBoolean(false);
        this.lastSequenceToken = new AtomicReference<Object>(null);
    }
}

