/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.jacoco;

import com.teamscale.client.FileSystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class CoverageFile {
    private final File coverageFile;
    private int referenceCounter = 0;

    public CoverageFile(File coverageFile) {
        this.coverageFile = coverageFile;
    }

    public CoverageFile acquireReference() {
        ++this.referenceCounter;
        return this;
    }

    public void copy(OutputStream outputStream) throws IOException {
        FileInputStream inputStream = new FileInputStream(this.coverageFile);
        FileSystemUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public String getNameWithoutExtension() {
        return FileSystemUtils.getFilenameWithoutExtension((File)this.coverageFile);
    }

    public String getName() {
        return this.coverageFile.getName();
    }

    public void delete() throws IOException {
        --this.referenceCounter;
        if (this.referenceCounter <= 0) {
            Files.delete(this.coverageFile.toPath());
        }
    }

    public RequestBody createFormRequestBody() {
        return RequestBody.create((MediaType)MultipartBody.FORM, (File)new File(this.coverageFile.getAbsolutePath()));
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            return new FileOutputStream(this.coverageFile);
        }
        catch (IOException e) {
            throw new IOException("Could not create temporary coverage file" + this + ". This is used to cache the coverage file on disk before uploading it to its final destination. This coverage is lost. Please fix the underlying issue to avoid losing coverage.", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverageFile that = (CoverageFile)o;
        return this.coverageFile.equals(that.coverageFile);
    }

    public int hashCode() {
        return Objects.hash(this.coverageFile);
    }

    public String toString() {
        return this.coverageFile.getAbsolutePath();
    }
}

