/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.teamscale.client.StringUtils;
import com.teamscale.report.testwise.model.TestInfo;
import com.teamscale.report.testwise.model.builder.TestCoverageBuilder;
import com.teamscale.report.testwise.model.factory.TestInfoFactory;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class TestwiseCoverageReportWriter
implements Consumer<TestCoverageBuilder>,
AutoCloseable {
    private final TestInfoFactory testInfoFactory;
    private final JsonAdapter<TestInfo> testInfoJsonAdapter;
    private final File outputFile;
    private final int splitAfter;
    private JsonWriter writer;
    private int testsWritten = 0;
    private int testFileCounter = 0;

    public TestwiseCoverageReportWriter(TestInfoFactory testInfoFactory, File outputFile, int splitAfter) throws IOException {
        this.testInfoFactory = testInfoFactory;
        this.outputFile = outputFile;
        this.splitAfter = splitAfter;
        this.testInfoJsonAdapter = new Moshi.Builder().build().adapter(TestInfo.class).indent("\t");
        this.startReport();
    }

    @Override
    public void accept(TestCoverageBuilder testCoverageBuilder) {
        TestInfo testInfo = this.testInfoFactory.createFor(testCoverageBuilder);
        try {
            this.writeTestInfo(testInfo);
        }
        catch (IOException e) {
            throw new RuntimeException("Writing test info to report failed.", e);
        }
    }

    @Override
    public void close() throws IOException {
        for (TestInfo testInfo : this.testInfoFactory.createTestInfosWithoutCoverage()) {
            this.writeTestInfo(testInfo);
        }
        this.endReport();
    }

    private void startReport() throws IOException {
        ++this.testFileCounter;
        this.writer = JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink((File)this.getOutputFile(this.testFileCounter))));
        this.writer.beginObject();
        this.writer.name("tests");
        this.writer.beginArray();
    }

    private File getOutputFile(int testFileCounter) {
        String name = this.outputFile.getName();
        name = StringUtils.stripSuffix((String)name, (String)".json");
        name = name + "-" + testFileCounter + ".json";
        return new File(this.outputFile.getParent(), name);
    }

    private void writeTestInfo(TestInfo testInfo) throws IOException {
        if (this.testsWritten >= this.splitAfter) {
            this.endReport();
            this.testsWritten = 0;
            this.startReport();
        }
        this.testInfoJsonAdapter.toJson(this.writer, (Object)testInfo);
        ++this.testsWritten;
    }

    private void endReport() throws IOException {
        this.writer.endArray();
        this.writer.endObject();
        this.writer.close();
    }
}

