/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.jacoco.cache;

import com.teamscale.report.jacoco.FilteringAnalyzer;
import com.teamscale.report.testwise.jacoco.cache.ClassCoverageLookup;
import com.teamscale.report.testwise.jacoco.cache.ProbesCache;
import com.teamscale.report.util.ClasspathWildcardIncludeFilter;
import com.teamscale.report.util.ILogger;
import java.io.IOException;
import org.jacoco.core.internal.analysis.CachingClassAnalyzer;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.data.CRC64;
import org.jacoco.core.internal.flow.ClassProbesAdapter;
import org.jacoco.core.internal.flow.ClassProbesVisitor;
import org.jacoco.core.internal.instr.InstrSupport;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AnalyzerCache
extends FilteringAnalyzer {
    private final ProbesCache probesCache;
    private final StringPool stringPool = new StringPool();

    public AnalyzerCache(ProbesCache probesCache, ClasspathWildcardIncludeFilter locationIncludeFilter, ILogger logger) {
        super(null, null, locationIncludeFilter, logger);
        this.probesCache = probesCache;
    }

    private void analyzeClass(byte[] source) {
        long classId = CRC64.classId((byte[])source);
        if (this.probesCache.containsClassId(classId)) {
            return;
        }
        ClassReader reader = InstrSupport.classReaderFor((byte[])source);
        ClassCoverageLookup classCoverageLookup = this.probesCache.createClass(classId, reader.getClassName());
        ClassCoverageImpl dummyClassCoverage = new ClassCoverageImpl(reader.getClassName(), classId, false);
        CachingClassAnalyzer classAnalyzer = new CachingClassAnalyzer(classCoverageLookup, dummyClassCoverage, this.stringPool);
        ClassProbesAdapter visitor = new ClassProbesAdapter((ClassProbesVisitor)classAnalyzer, false);
        reader.accept((ClassVisitor)visitor, 0);
    }

    public void analyzeClass(byte[] buffer, String location) throws IOException {
        try {
            this.analyzeClass(buffer);
        }
        catch (RuntimeException cause) {
            throw new IOException(String.format("Error while analyzing %s.", location), cause);
        }
    }
}

