/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.jacoco.cache;

import com.teamscale.report.util.ILogger;
import java.util.HashSet;
import java.util.Set;

class ClassNotFoundLogger {
    private final ILogger logger;
    private final Set<String> classesToBeLogged = new HashSet<String>();
    private final Set<String> alreadyLoggedClasses = new HashSet<String>();

    ClassNotFoundLogger(ILogger logger) {
        this.logger = logger;
    }

    void log(String fullyQualifiedClassName) {
        if (!this.alreadyLoggedClasses.contains(fullyQualifiedClassName)) {
            this.classesToBeLogged.add(fullyQualifiedClassName);
        }
    }

    void flush() {
        if (this.classesToBeLogged.isEmpty()) {
            return;
        }
        this.logger.warn("Found coverage for " + this.classesToBeLogged.size() + " classes that were not provided. Either you did not provide all relevant class files or you did not adjust the include/exclude filters on the agent to exclude coverage from irrelevant code. The classes are:");
        for (String fullyQualifiedClassName : this.classesToBeLogged) {
            this.logger.warn(" - " + fullyQualifiedClassName);
        }
        this.alreadyLoggedClasses.addAll(this.classesToBeLogged);
        this.classesToBeLogged.clear();
    }
}

