/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.jacoco.cache;

import com.teamscale.report.EDuplicateClassFileBehavior;
import com.teamscale.report.testwise.jacoco.cache.ClassCoverageLookup;
import com.teamscale.report.testwise.jacoco.cache.ClassNotFoundLogger;
import com.teamscale.report.testwise.jacoco.cache.CoverageGenerationException;
import com.teamscale.report.testwise.model.builder.FileCoverageBuilder;
import com.teamscale.report.util.ClasspathWildcardIncludeFilter;
import com.teamscale.report.util.ILogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.report.JavaNames;

public class ProbesCache {
    private final ILogger logger;
    private final HashMap<Long, ClassCoverageLookup> classCoverageLookups = new HashMap();
    private final Set<String> containedClasses = new HashSet<String>();
    private final EDuplicateClassFileBehavior duplicateClassFileBehavior;
    private final ClassNotFoundLogger classNotFoundLogger;

    public ProbesCache(ILogger logger, EDuplicateClassFileBehavior duplicateClassFileBehavior) {
        this.logger = logger;
        this.classNotFoundLogger = new ClassNotFoundLogger(logger);
        this.duplicateClassFileBehavior = duplicateClassFileBehavior;
    }

    public ClassCoverageLookup createClass(long classId, String className) {
        if (this.containedClasses.contains(className)) {
            if (this.duplicateClassFileBehavior != EDuplicateClassFileBehavior.IGNORE) {
                this.logger.warn("Non-identical class file for class " + className + ". This happens when a class with the same fully-qualified name is loaded twice but the two loaded class files are not identical. A common reason for this is that the same library or shared code is included twice in your application but in two different versions. The produced coverage for this class may not be accurate or may even be unusable. To fix this problem, please resolve the conflict between both class files in your application.");
            }
            if (this.duplicateClassFileBehavior == EDuplicateClassFileBehavior.FAIL) {
                throw new IllegalStateException("Found non-identical class file for class " + className + ". See logs for more details.");
            }
        }
        this.containedClasses.add(className);
        ClassCoverageLookup classCoverageLookup = new ClassCoverageLookup(className);
        this.classCoverageLookups.put(classId, classCoverageLookup);
        return classCoverageLookup;
    }

    public boolean containsClassId(long classId) {
        return this.classCoverageLookups.containsKey(classId);
    }

    public FileCoverageBuilder getCoverage(ExecutionData executionData, ClasspathWildcardIncludeFilter locationIncludeFilter) throws CoverageGenerationException {
        long classId = executionData.getId();
        if (!this.containsClassId(classId)) {
            String fullyQualifiedClassName = new JavaNames().getQualifiedClassName(executionData.getName());
            if (locationIncludeFilter.isIncluded(fullyQualifiedClassName + ".class")) {
                this.classNotFoundLogger.log(fullyQualifiedClassName);
            }
            return null;
        }
        if (!executionData.hasHits()) {
            return null;
        }
        return this.classCoverageLookups.get(classId).getFileCoverage(executionData, this.logger);
    }

    public boolean isEmpty() {
        return this.classCoverageLookups.isEmpty();
    }

    public void flushLogger() {
        this.classNotFoundLogger.flush();
    }
}

