/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.model.factory;

import com.teamscale.client.TestDetails;
import com.teamscale.report.testwise.model.TestExecution;
import com.teamscale.report.testwise.model.TestInfo;
import com.teamscale.report.testwise.model.builder.TestCoverageBuilder;
import com.teamscale.report.testwise.model.builder.TestInfoBuilder;
import com.teamscale.report.testwise.model.builder.TestwiseCoverageReportBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestInfoFactory {
    private Map<String, TestDetails> testDetailsMap = new HashMap<String, TestDetails>();
    private Map<String, TestExecution> testExecutionsMap = new HashMap<String, TestExecution>();
    private final Set<String> processedTestUniformPaths = new HashSet<String>();

    public TestInfoFactory(List<TestDetails> testDetails, List<TestExecution> testExecutions) {
        for (TestDetails testDetail : testDetails) {
            this.testDetailsMap.put(testDetail.uniformPath, testDetail);
        }
        for (TestExecution testExecution : testExecutions) {
            this.testExecutionsMap.put(testExecution.getUniformPath(), testExecution);
        }
    }

    public TestInfo createFor(TestCoverageBuilder testCoverageBuilder) {
        String resolvedUniformPath = this.resolveUniformPath(testCoverageBuilder.getUniformPath());
        this.processedTestUniformPaths.add(resolvedUniformPath);
        TestInfoBuilder container = new TestInfoBuilder(resolvedUniformPath);
        container.setCoverage(testCoverageBuilder);
        TestDetails testDetails = this.testDetailsMap.get(resolvedUniformPath);
        if (testDetails == null) {
            System.err.println("No test details found for " + resolvedUniformPath);
        }
        container.setDetails(testDetails);
        TestExecution execution = this.testExecutionsMap.get(resolvedUniformPath);
        if (execution == null) {
            System.err.println("No test execution found for " + resolvedUniformPath);
        }
        container.setExecution(execution);
        return container.build();
    }

    public List<TestInfo> createTestInfosWithoutCoverage() {
        ArrayList<TestInfo> results = new ArrayList<TestInfo>();
        for (TestDetails testDetails : this.testDetailsMap.values()) {
            if (this.processedTestUniformPaths.contains(testDetails.uniformPath)) continue;
            TestInfoBuilder testInfo = new TestInfoBuilder(testDetails.uniformPath);
            testInfo.setDetails(testDetails);
            testInfo.setExecution(this.testExecutionsMap.get(testDetails.uniformPath));
            results.add(testInfo.build());
            this.processedTestUniformPaths.add(testDetails.uniformPath);
        }
        for (TestExecution testExecution : this.testExecutionsMap.values()) {
            if (this.processedTestUniformPaths.contains(testExecution.getUniformPath())) continue;
            System.err.println("Test " + testExecution.getUniformPath() + " was executed but no coverage was found. Please make sure that you did provide all relevant exec files and that the test IDs passed to the agent match the ones from the provided test execution list.");
            this.processedTestUniformPaths.add(testExecution.getUniformPath());
        }
        return results;
    }

    private String resolveUniformPath(String originalUniformPath) {
        String uniformPath = originalUniformPath;
        TestDetails testDetails = this.testDetailsMap.get(uniformPath);
        if (testDetails == null) {
            uniformPath = TestwiseCoverageReportBuilder.stripParameterizedTestArguments(uniformPath);
        }
        return uniformPath;
    }
}

