/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.util;

import com.teamscale.client.FileSystemUtils;
import com.teamscale.client.StringUtils;
import org.jacoco.core.runtime.WildcardMatcher;
import org.jacoco.report.JavaNames;

public class ClasspathWildcardIncludeFilter {
    private WildcardMatcher locationIncludeFilters = null;
    private WildcardMatcher locationExcludeFilters = null;

    public ClasspathWildcardIncludeFilter(String locationIncludeFilters, String locationExcludeFilters) {
        if (locationIncludeFilters != null && !locationIncludeFilters.isEmpty()) {
            this.locationIncludeFilters = new WildcardMatcher(locationIncludeFilters);
        }
        if (locationExcludeFilters != null && !locationExcludeFilters.isEmpty()) {
            this.locationExcludeFilters = new WildcardMatcher(locationExcludeFilters);
        }
    }

    public boolean isIncluded(String path) {
        String className = ClasspathWildcardIncludeFilter.getClassName(path);
        if (this.locationIncludeFilters != null && !this.locationIncludeFilters.matches(className)) {
            return false;
        }
        return this.locationExcludeFilters == null || !this.locationExcludeFilters.matches(className);
    }

    static String getClassName(String path) {
        String[] parts = FileSystemUtils.normalizeSeparators((String)path).split("@");
        if (parts.length == 0) {
            return "";
        }
        String pathInsideJar = parts[parts.length - 1];
        if (path.toLowerCase().endsWith(".class")) {
            pathInsideJar = StringUtils.removeLastPart((String)pathInsideJar, (char)'.');
        }
        return new JavaNames().getQualifiedClassName(pathInsideJar);
    }
}

