/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.teamscale.client.FileSystemUtils;
import com.teamscale.client.TestDetails;
import com.teamscale.report.testwise.ETestArtifactFormat;
import com.teamscale.report.testwise.model.TestExecution;
import com.teamscale.report.testwise.model.TestwiseCoverageReport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class ReportUtils {
    private static Moshi moshi = new Moshi.Builder().build();
    private static JsonAdapter<List<TestDetails>> testDetailsAdapter = moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{TestDetails.class})).indent("\t");
    private static JsonAdapter<List<TestExecution>> testExecutionAdapter = moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{TestExecution.class})).indent("\t");
    private static JsonAdapter<TestwiseCoverageReport> testwiseCoverageReportAdapter = moshi.adapter(TestwiseCoverageReport.class).indent("\t");

    public static void writeTestListReport(File reportFile, List<TestDetails> report) throws IOException {
        ReportUtils.writeReportToFile(reportFile, report, testDetailsAdapter);
    }

    public static void writeTestExecutionReport(File reportFile, List<TestExecution> report) throws IOException {
        ReportUtils.writeReportToFile(reportFile, report, testExecutionAdapter);
    }

    public static void writeTestwiseCoverageReport(File reportFile, TestwiseCoverageReport report) throws IOException {
        ReportUtils.writeReportToFile(reportFile, report, testwiseCoverageReportAdapter);
    }

    public static String getTestwiseCoverageReportAsString(TestwiseCoverageReport report) {
        return testwiseCoverageReportAdapter.toJson((Object)report);
    }

    private static <T> void writeReportToFile(File reportFile, T report, JsonAdapter<T> adapter) throws IOException {
        File directory = reportFile.getParentFile();
        if (!directory.isDirectory() && !directory.mkdirs()) {
            throw new IOException("Failed to create directory " + directory.getAbsolutePath());
        }
        try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)reportFile));){
            adapter.toJson(sink, report);
        }
    }

    public static <T> List<T> readObjects(ETestArtifactFormat format, Class<T[]> clazz, List<File> directoriesOrFiles) throws IOException {
        List<File> files = ReportUtils.listFiles(format, directoriesOrFiles);
        ArrayList<Object> result = new ArrayList<Object>();
        for (File file : files) {
            BufferedSource source = Okio.buffer((Source)Okio.source((File)file));
            Throwable throwable = null;
            try {
                Object[] t = (Object[])moshi.adapter(clazz).fromJson(source);
                if (t == null) continue;
                result.addAll(Arrays.asList(t));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (source == null) continue;
                if (throwable != null) {
                    try {
                        source.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                source.close();
            }
        }
        return result;
    }

    public static List<File> listFiles(ETestArtifactFormat format, List<File> directoriesOrFiles) {
        ArrayList<File> filesWithSpecifiedArtifactType = new ArrayList<File>();
        for (File directoryOrFile : directoriesOrFiles) {
            if (directoryOrFile.isDirectory()) {
                filesWithSpecifiedArtifactType.addAll(FileSystemUtils.listFilesRecursively((File)directoryOrFile, file -> ReportUtils.fileIsOfArtifactFormat(file, format)));
                continue;
            }
            if (!ReportUtils.fileIsOfArtifactFormat(directoryOrFile, format)) continue;
            filesWithSpecifiedArtifactType.add(directoryOrFile);
        }
        return filesWithSpecifiedArtifactType;
    }

    private static boolean fileIsOfArtifactFormat(File file, ETestArtifactFormat format) {
        return file.isFile() && file.getName().startsWith(format.filePrefix) && FileSystemUtils.getFileExtension((File)file).equalsIgnoreCase(format.extension);
    }
}

