/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.jacoco;

import com.teamscale.report.EDuplicateClassFileBehavior;
import com.teamscale.report.jacoco.CoverageFile;
import com.teamscale.report.jacoco.EmptyReportException;
import com.teamscale.report.jacoco.FilteringAnalyzer;
import com.teamscale.report.jacoco.TeamscaleCoverageBuilder;
import com.teamscale.report.jacoco.dump.Dump;
import com.teamscale.report.util.ClasspathWildcardIncludeFilter;
import com.teamscale.report.util.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.xml.XMLFormatter;

public class JaCoCoXmlReportGenerator {
    private final ILogger logger;
    private final List<File> codeDirectoriesOrArchives;
    private final ClasspathWildcardIncludeFilter locationIncludeFilter;
    private final EDuplicateClassFileBehavior duplicateClassFileBehavior;
    private final boolean ignoreUncoveredClasses;
    private static final String MOST_LIKELY_CAUSE_MESSAGE = "Most likely you did not configure the agent correctly. Please check that the includes and excludes options are set correctly so the relevant code is included. If in doubt, first include more code and then iteratively narrow the patterns down to just the relevant code. If you have specified the class-dir option, please make sure it points to a directory containing the class files/jars/wars/ears/etc. for which you are trying to measure code coverage.";

    public JaCoCoXmlReportGenerator(List<File> codeDirectoriesOrArchives, ClasspathWildcardIncludeFilter locationIncludeFilter, EDuplicateClassFileBehavior duplicateClassFileBehavior, boolean ignoreUncoveredClasses, ILogger logger) {
        this.codeDirectoriesOrArchives = codeDirectoriesOrArchives;
        this.duplicateClassFileBehavior = duplicateClassFileBehavior;
        this.locationIncludeFilter = locationIncludeFilter;
        this.ignoreUncoveredClasses = ignoreUncoveredClasses;
        this.logger = logger;
    }

    public CoverageFile convert(Dump dump, File filePath) throws IOException, EmptyReportException {
        CoverageFile coverageFile = new CoverageFile(filePath);
        this.convertToReport(coverageFile, dump);
        return coverageFile;
    }

    private void convertToReport(CoverageFile coverageFile, Dump dump) throws IOException, EmptyReportException {
        ExecutionDataStore mergedStore = dump.store;
        IBundleCoverage bundleCoverage = this.analyzeStructureAndAnnotateCoverage(mergedStore);
        this.checkForEmptyReport(bundleCoverage);
        try (OutputStream outputStream = coverageFile.getOutputStream();){
            JaCoCoXmlReportGenerator.createReport(outputStream, bundleCoverage, dump.info, mergedStore);
        }
    }

    private void checkForEmptyReport(IBundleCoverage coverage) throws EmptyReportException {
        if (coverage.getPackages().size() == 0 || coverage.getLineCounter().getTotalCount() == 0) {
            throw new EmptyReportException("The generated coverage report is empty. Most likely you did not configure the agent correctly. Please check that the includes and excludes options are set correctly so the relevant code is included. If in doubt, first include more code and then iteratively narrow the patterns down to just the relevant code. If you have specified the class-dir option, please make sure it points to a directory containing the class files/jars/wars/ears/etc. for which you are trying to measure code coverage.");
        }
        if (coverage.getLineCounter().getCoveredCount() == 0) {
            throw new EmptyReportException("The generated coverage report does not contain any covered source code lines. Most likely you did not configure the agent correctly. Please check that the includes and excludes options are set correctly so the relevant code is included. If in doubt, first include more code and then iteratively narrow the patterns down to just the relevant code. If you have specified the class-dir option, please make sure it points to a directory containing the class files/jars/wars/ears/etc. for which you are trying to measure code coverage.");
        }
    }

    private static void createReport(OutputStream output, IBundleCoverage bundleCoverage, SessionInfo sessionInfo, ExecutionDataStore store) throws IOException {
        XMLFormatter xmlFormatter = new XMLFormatter();
        IReportVisitor visitor = xmlFormatter.createVisitor(output);
        visitor.visitInfo(Collections.singletonList(sessionInfo), store.getContents());
        visitor.visitBundle(bundleCoverage, null);
        visitor.visitEnd();
    }

    private IBundleCoverage analyzeStructureAndAnnotateCoverage(ExecutionDataStore store) throws IOException {
        TeamscaleCoverageBuilder coverageBuilder = new TeamscaleCoverageBuilder(this.logger, this.duplicateClassFileBehavior, this.ignoreUncoveredClasses);
        FilteringAnalyzer analyzer = new FilteringAnalyzer(store, (ICoverageVisitor)coverageBuilder, this.locationIncludeFilter, this.logger);
        for (File file : this.codeDirectoriesOrArchives) {
            analyzer.analyzeAll(file);
        }
        return coverageBuilder.getBundle("dummybundle");
    }
}

