/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.jacoco;

import com.teamscale.report.EDuplicateClassFileBehavior;
import com.teamscale.report.jacoco.dump.Dump;
import com.teamscale.report.testwise.jacoco.cache.AnalyzerCache;
import com.teamscale.report.testwise.jacoco.cache.CoverageGenerationException;
import com.teamscale.report.testwise.jacoco.cache.ProbesCache;
import com.teamscale.report.testwise.model.builder.TestCoverageBuilder;
import com.teamscale.report.util.ClasspathWildcardIncludeFilter;
import com.teamscale.report.util.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;

class CachingExecutionDataReader {
    private final ILogger logger;
    private final Collection<File> classesDirectories;
    private final ClasspathWildcardIncludeFilter locationIncludeFilter;
    private final EDuplicateClassFileBehavior duplicateClassFileBehavior;
    private ProbesCache probesCache;

    public CachingExecutionDataReader(ILogger logger, Collection<File> classesDirectories, ClasspathWildcardIncludeFilter locationIncludeFilter, EDuplicateClassFileBehavior duplicateClassFileBehavior) {
        this.logger = logger;
        this.classesDirectories = classesDirectories;
        this.locationIncludeFilter = locationIncludeFilter;
        this.duplicateClassFileBehavior = duplicateClassFileBehavior;
    }

    public void analyzeClassDirs() {
        if (this.probesCache == null) {
            this.probesCache = new ProbesCache(this.logger, this.duplicateClassFileBehavior);
        }
        if (this.classesDirectories.isEmpty()) {
            this.logger.warn("No class directories found for caching.");
            return;
        }
        AnalyzerCache analyzer = new AnalyzerCache(this.probesCache, this.locationIncludeFilter, this.logger);
        for (File classDir : this.classesDirectories) {
            if (!classDir.exists()) continue;
            try {
                analyzer.analyzeAll(classDir);
            }
            catch (IOException e) {
                this.logger.error("Failed to analyze class files in " + classDir + "! Maybe the folder contains incompatible class files. Coverage for class files in this folder will be ignored.", e);
            }
        }
        if (this.probesCache.isEmpty()) {
            String directoryList = this.classesDirectories.stream().map(File::getPath).collect(Collectors.joining(","));
            this.logger.error("No class files found in the given directories! " + directoryList);
        }
    }

    public DumpConsumer buildCoverageConsumer(ClasspathWildcardIncludeFilter locationIncludeFilter, Consumer<TestCoverageBuilder> nextConsumer) {
        return new DumpConsumer(this.logger, locationIncludeFilter, nextConsumer);
    }

    public class DumpConsumer
    implements Consumer<Dump> {
        private final ILogger logger;
        private final ClasspathWildcardIncludeFilter locationIncludeFilter;
        private final Consumer<TestCoverageBuilder> nextConsumer;

        private DumpConsumer(ILogger logger, ClasspathWildcardIncludeFilter locationIncludeFilter, Consumer<TestCoverageBuilder> nextConsumer) {
            this.logger = logger;
            this.locationIncludeFilter = locationIncludeFilter;
            this.nextConsumer = nextConsumer;
        }

        @Override
        public void accept(Dump dump) {
            String testId = dump.info.getId();
            if (testId.isEmpty()) {
                this.logger.debug("Found a session with empty name! This could indicate that coverage is dumped also for coverage in between tests or that the given test name was empty!");
                return;
            }
            try {
                TestCoverageBuilder testCoverage = this.buildCoverage(testId, dump.store, this.locationIncludeFilter);
                this.nextConsumer.accept(testCoverage);
            }
            catch (CoverageGenerationException e) {
                this.logger.error("Failed to generate coverage for test " + testId + "! Skipping to the next test.", e);
            }
        }

        private TestCoverageBuilder buildCoverage(String testId, ExecutionDataStore executionDataStore, ClasspathWildcardIncludeFilter locationIncludeFilter) throws CoverageGenerationException {
            TestCoverageBuilder testCoverage = new TestCoverageBuilder(testId);
            for (ExecutionData executionData : executionDataStore.getContents()) {
                testCoverage.add(CachingExecutionDataReader.this.probesCache.getCoverage(executionData, locationIncludeFilter));
            }
            CachingExecutionDataReader.this.probesCache.flushLogger();
            return testCoverage;
        }
    }
}

