/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.jacoco;

import com.teamscale.report.EDuplicateClassFileBehavior;
import com.teamscale.report.jacoco.dump.Dump;
import com.teamscale.report.testwise.jacoco.CachingExecutionDataReader;
import com.teamscale.report.testwise.jacoco.cache.CoverageGenerationException;
import com.teamscale.report.testwise.model.TestwiseCoverage;
import com.teamscale.report.testwise.model.builder.TestCoverageBuilder;
import com.teamscale.report.util.ClasspathWildcardIncludeFilter;
import com.teamscale.report.util.ILogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;

public class JaCoCoTestwiseReportGenerator {
    private final CachingExecutionDataReader executionDataReader;
    private final ClasspathWildcardIncludeFilter locationIncludeFilter;

    public JaCoCoTestwiseReportGenerator(Collection<File> codeDirectoriesOrArchives, ClasspathWildcardIncludeFilter locationIncludeFilter, EDuplicateClassFileBehavior duplicateClassFileBehavior, ILogger logger) {
        this.locationIncludeFilter = locationIncludeFilter;
        this.executionDataReader = new CachingExecutionDataReader(logger, codeDirectoriesOrArchives, locationIncludeFilter, duplicateClassFileBehavior);
        this.updateClassDirCache();
    }

    public void updateClassDirCache() {
        this.executionDataReader.analyzeClassDirs();
    }

    public TestwiseCoverage convert(File executionDataFile) throws IOException, CoverageGenerationException {
        TestwiseCoverage testwiseCoverage = new TestwiseCoverage();
        CachingExecutionDataReader.DumpConsumer dumpConsumer = this.executionDataReader.buildCoverageConsumer(this.locationIncludeFilter, testwiseCoverage::add);
        this.readAndConsumeDumps(executionDataFile, dumpConsumer);
        return testwiseCoverage;
    }

    public TestCoverageBuilder convert(Dump dump) throws CoverageGenerationException {
        ArrayList list = new ArrayList();
        CachingExecutionDataReader.DumpConsumer dumpConsumer = this.executionDataReader.buildCoverageConsumer(this.locationIncludeFilter, list::add);
        dumpConsumer.accept(dump);
        if (list.size() == 1) {
            return (TestCoverageBuilder)list.get(0);
        }
        return null;
    }

    public void convertAndConsume(File executionDataFile, Consumer<TestCoverageBuilder> consumer) throws IOException {
        CachingExecutionDataReader.DumpConsumer dumpConsumer = this.executionDataReader.buildCoverageConsumer(this.locationIncludeFilter, consumer);
        this.readAndConsumeDumps(executionDataFile, dumpConsumer);
    }

    private void readAndConsumeDumps(File executionDataFile, Consumer<Dump> dumpConsumer) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(executionDataFile));){
            ExecutionDataReader executionDataReader = new ExecutionDataReader((InputStream)input);
            DumpCallback dumpCallback = new DumpCallback(dumpConsumer);
            executionDataReader.setExecutionDataVisitor((IExecutionDataVisitor)dumpCallback);
            executionDataReader.setSessionInfoVisitor((ISessionInfoVisitor)dumpCallback);
            executionDataReader.read();
            dumpCallback.processDump();
        }
    }

    private static class DumpCallback
    implements IExecutionDataVisitor,
    ISessionInfoVisitor {
        private Dump currentDump = null;
        private ExecutionDataStore store;
        private final Consumer<Dump> dumpConsumer;

        private DumpCallback(Consumer<Dump> dumpConsumer) {
            this.dumpConsumer = dumpConsumer;
        }

        public void visitSessionInfo(SessionInfo info) {
            this.processDump();
            this.store = new ExecutionDataStore();
            this.currentDump = new Dump(info, this.store);
        }

        public void visitClassExecution(ExecutionData data) {
            this.store.put(data);
        }

        private void processDump() {
            if (this.currentDump != null) {
                this.dumpConsumer.accept(this.currentDump);
                this.currentDump = null;
            }
        }
    }
}

