/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.model.builder;

import com.teamscale.report.testwise.model.FileCoverage;
import com.teamscale.report.testwise.model.LineRange;
import com.teamscale.report.util.SortedIntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FileCoverageBuilder {
    private final String path;
    private final String fileName;
    private final SortedIntList coveredLines = new SortedIntList();

    public FileCoverageBuilder(String path, String fileName) {
        this.path = path;
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public void addLine(int line) {
        this.coveredLines.add(line);
    }

    public void addLineRange(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.coveredLines.add(i);
        }
    }

    public void addLines(SortedIntList range) {
        this.coveredLines.addAll(range);
    }

    public void merge(FileCoverageBuilder other) {
        if (!other.fileName.equals(this.fileName) || !other.path.equals(this.path)) {
            throw new AssertionError((Object)"Cannot merge coverage of two different files! This is a bug!");
        }
        this.coveredLines.addAll(other.coveredLines);
    }

    public static List<LineRange> compactifyToRanges(SortedIntList lines) {
        if (lines.size() == 0) {
            return new ArrayList<LineRange>();
        }
        int firstLine = lines.get(0);
        LineRange currentRange = new LineRange(firstLine, firstLine);
        ArrayList<LineRange> compactifiedRanges = new ArrayList<LineRange>();
        compactifiedRanges.add(currentRange);
        for (int i = 0; i < lines.size(); ++i) {
            int currentLine = lines.get(i);
            if (currentRange.getEnd() == currentLine || currentRange.getEnd() == currentLine - 1) {
                currentRange.setEnd(currentLine);
                continue;
            }
            currentRange = new LineRange(currentLine, currentLine);
            compactifiedRanges.add(currentRange);
        }
        return compactifiedRanges;
    }

    public String computeCompactifiedRangesAsString() {
        List<LineRange> coveredRanges = FileCoverageBuilder.compactifyToRanges(this.coveredLines);
        return coveredRanges.stream().map(LineRange::toReportString).collect(Collectors.joining(","));
    }

    public boolean isEmpty() {
        return this.coveredLines.size() == 0;
    }

    public FileCoverage build() {
        return new FileCoverage(this.fileName, this.computeCompactifiedRangesAsString());
    }
}

