/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.model.builder;

import com.teamscale.report.testwise.model.FileCoverage;
import com.teamscale.report.testwise.model.PathCoverage;
import com.teamscale.report.testwise.model.builder.FileCoverageBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PathCoverageBuilder {
    private final String path;
    private final Map<String, FileCoverageBuilder> fileCoverageList = new HashMap<String, FileCoverageBuilder>();

    public PathCoverageBuilder(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void add(FileCoverageBuilder fileCoverage) {
        if (this.fileCoverageList.containsKey(fileCoverage.getFileName())) {
            FileCoverageBuilder existingFile = this.fileCoverageList.get(fileCoverage.getFileName());
            existingFile.merge(fileCoverage);
        } else {
            this.fileCoverageList.put(fileCoverage.getFileName(), fileCoverage);
        }
    }

    public Collection<FileCoverageBuilder> getFiles() {
        return this.fileCoverageList.values();
    }

    public PathCoverage build() {
        List<FileCoverage> files = this.fileCoverageList.values().stream().sorted(Comparator.comparing(FileCoverageBuilder::getFileName)).map(FileCoverageBuilder::build).collect(Collectors.toList());
        return new PathCoverage(this.path, files);
    }
}

