/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.model.builder;

import com.teamscale.client.TestDetails;
import com.teamscale.report.testwise.model.ETestExecutionResult;
import com.teamscale.report.testwise.model.TestExecution;
import com.teamscale.report.testwise.model.TestInfo;
import com.teamscale.report.testwise.model.builder.TestCoverageBuilder;

public class TestInfoBuilder {
    public final String uniformPath;
    private String sourcePath = null;
    private String content = null;
    private Double durationSeconds = null;
    private ETestExecutionResult result;
    private String message;
    private TestCoverageBuilder coverage;

    public TestInfoBuilder(String uniformPath) {
        this.uniformPath = uniformPath;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public boolean isEmpty() {
        return this.coverage.isEmpty();
    }

    public void setDetails(TestDetails details) {
        if (details != null) {
            this.sourcePath = details.sourcePath;
            this.content = details.content;
        }
    }

    public void setExecution(TestExecution execution) {
        if (execution != null) {
            this.durationSeconds = execution.getDurationSeconds();
            this.result = execution.getResult();
            this.message = execution.getMessage();
        }
    }

    public void setCoverage(TestCoverageBuilder coverage) {
        this.coverage = coverage;
    }

    public TestInfo build() {
        TestInfo testInfo = new TestInfo(this.uniformPath, this.sourcePath, this.content, this.durationSeconds, this.result, this.message);
        if (this.coverage != null) {
            testInfo.paths.addAll(this.coverage.getPaths());
        }
        return testInfo;
    }
}

