/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import com.teamscale.report.testwise.jacoco.cache.ClassCoverageLookup;
import com.teamscale.report.util.SortedIntList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jacoco.core.internal.analysis.Instruction;
import org.jacoco.core.internal.analysis.InstructionsBuilder;
import org.jacoco.core.internal.flow.LabelInfo;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;

public class CachingInstructionsBuilder
extends InstructionsBuilder {
    private final ClassCoverageLookup classCoverageLookup;
    private final List<CoveredProbe> coveredProbes = new ArrayList<CoveredProbe>();
    private int currentLine;
    private Instruction currentInsn;
    private final Map<AbstractInsnNode, Instruction> instructions;
    private final List<Label> currentLabel;
    private final List<Jump> jumps;

    public CachingInstructionsBuilder(ClassCoverageLookup classCoverageLookup) {
        super(null);
        this.classCoverageLookup = classCoverageLookup;
        this.currentLine = -1;
        this.currentInsn = null;
        this.instructions = new HashMap<AbstractInsnNode, Instruction>();
        this.currentLabel = new ArrayList<Label>(2);
        this.jumps = new ArrayList<Jump>();
    }

    void setCurrentLine(int line) {
        this.currentLine = line;
    }

    void addLabel(Label label) {
        this.currentLabel.add(label);
        if (!LabelInfo.isSuccessor((Label)label)) {
            this.noSuccessor();
        }
    }

    void addInstruction(AbstractInsnNode node) {
        Instruction insn = new Instruction(this.currentLine);
        int labelCount = this.currentLabel.size();
        if (labelCount > 0) {
            int i = labelCount;
            while (--i >= 0) {
                LabelInfo.setInstruction((Label)this.currentLabel.get(i), (Instruction)insn);
            }
            this.currentLabel.clear();
        }
        if (this.currentInsn != null) {
            this.currentInsn.addBranch(insn, 0);
        }
        this.currentInsn = insn;
        this.instructions.put(node, insn);
    }

    void noSuccessor() {
        this.currentInsn = null;
    }

    void addJump(Label target, int branch) {
        this.jumps.add(new Jump(this.currentInsn, target, branch));
    }

    void addProbe(int probeId, int branch) {
        this.currentInsn.addBranch(true, branch);
        this.coveredProbes.add(new CoveredProbe(probeId, this.currentInsn, branch));
    }

    public void fillCache() {
        for (Jump j : this.jumps) {
            j.wire();
        }
        for (CoveredProbe coveredProbe : this.coveredProbes) {
            Instruction instruction = coveredProbe.instruction;
            SortedIntList coveredLines = new SortedIntList();
            while (instruction != null) {
                if (instruction.getLine() != -1) {
                    coveredLines.add(instruction.getLine());
                }
                instruction = this.getPredecessor(instruction);
            }
            this.classCoverageLookup.addProbe(coveredProbe.probeId, coveredLines);
        }
    }

    private Instruction getPredecessor(Instruction instruction) {
        try {
            Field predecessorField = instruction.getClass().getDeclaredField("predecessor");
            predecessorField.setAccessible(true);
            instruction = (Instruction)predecessorField.get(instruction);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Instruction has no field named predecessor! This is a programming error!", e);
        }
        return instruction;
    }

    private static class Jump {
        private final Instruction source;
        private final Label target;
        private final int branch;

        Jump(Instruction source, Label target, int branch) {
            this.source = source;
            this.target = target;
            this.branch = branch;
        }

        void wire() {
            this.source.addBranch(LabelInfo.getInstruction((Label)this.target), this.branch);
        }
    }

    private static class CoveredProbe {
        final int probeId;
        final Instruction instruction;
        final int branch;

        private CoveredProbe(int probeId, Instruction instruction, int branch) {
            this.probeId = probeId;
            this.instruction = instruction;
            this.branch = branch;
        }
    }
}

