/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.jacoco;

import com.teamscale.report.util.BashFileSkippingInputStream;
import com.teamscale.report.util.ClasspathWildcardIncludeFilter;
import com.teamscale.report.util.ILogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;

public class FilteringAnalyzer
extends Analyzer {
    private final ClasspathWildcardIncludeFilter locationIncludeFilter;
    private final ILogger logger;

    public FilteringAnalyzer(ExecutionDataStore executionData, ICoverageVisitor coverageVisitor, ClasspathWildcardIncludeFilter locationIncludeFilter, ILogger logger) {
        super(executionData, coverageVisitor);
        this.locationIncludeFilter = locationIncludeFilter;
        this.logger = logger;
    }

    public int analyzeAll(InputStream input, String location) throws IOException {
        if (location.endsWith(".class") && !this.locationIncludeFilter.isIncluded(location)) {
            this.logger.debug("Excluding class file " + location);
            return 1;
        }
        if (location.endsWith(".jar")) {
            return this.analyzeJar(input, location);
        }
        return super.analyzeAll(input, location);
    }

    private IOException analyzerError(String location, Exception cause) {
        return new IOException(String.format("Error while analyzing %s.", location), cause);
    }

    protected int analyzeJar(InputStream input, String location) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(new BashFileSkippingInputStream(input));
        int count = 0;
        while ((entry = this.nextEntry(zip, location)) != null) {
            count += this.analyzeAll(zip, location + "@" + entry.getName());
        }
        return count;
    }

    private ZipEntry nextEntry(ZipInputStream input, String location) throws IOException {
        try {
            return input.getNextEntry();
        }
        catch (IOException e) {
            throw this.analyzerError(location, e);
        }
    }
}

