/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.jacoco;

import com.teamscale.report.EDuplicateClassFileBehavior;
import com.teamscale.report.util.ILogger;
import java.util.Collections;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.internal.analysis.BundleCoverageImpl;

class TeamscaleCoverageBuilder
extends CoverageBuilder {
    private final ILogger logger;
    private final EDuplicateClassFileBehavior duplicateClassFileBehavior;
    private final boolean ignoreUncoveredClasses;

    TeamscaleCoverageBuilder(ILogger logger, EDuplicateClassFileBehavior duplicateClassFileBehavior, boolean removeUncoveredClasses) {
        this.logger = logger;
        this.duplicateClassFileBehavior = duplicateClassFileBehavior;
        this.ignoreUncoveredClasses = removeUncoveredClasses;
    }

    public IBundleCoverage getBundle(String name) {
        return new BundleCoverageImpl(name, Collections.emptyList(), this.getSourceFiles());
    }

    public void visitCoverage(IClassCoverage coverage) {
        if (this.ignoreUncoveredClasses && (coverage.getClassCounter().getStatus() & 2) == 0) {
            return;
        }
        try {
            super.visitCoverage(coverage);
        }
        catch (IllegalStateException e) {
            switch (this.duplicateClassFileBehavior) {
                case IGNORE: {
                    return;
                }
                case WARN: {
                    this.logger.warn("Ignoring duplicate, non-identical class file for class " + coverage.getName() + " compiled from source file " + coverage.getSourceFileName() + ". This happens when a class with the same fully-qualified name is loaded twice but the two loaded class files are not identical. A common reason for this is that the same library or shared code is included twice in your application but in two different versions. The produced coverage for this class may not be accurate or may even be unusable. To fix this problem, please resolve the conflict between both class files in your application.");
                    return;
                }
            }
            throw e;
        }
    }
}

