/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.jacoco.cache;

import com.teamscale.client.StringUtils;
import com.teamscale.report.testwise.jacoco.cache.CoverageGenerationException;
import com.teamscale.report.testwise.model.builder.FileCoverageBuilder;
import com.teamscale.report.util.ILogger;
import com.teamscale.report.util.SortedIntList;
import java.util.ArrayList;
import java.util.List;
import org.jacoco.core.data.ExecutionData;

public class ClassCoverageLookup {
    private String className;
    private String sourceFileName;
    private final List<SortedIntList> probes = new ArrayList<SortedIntList>();

    ClassCoverageLookup(String className) {
        this.className = className;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void setTotalProbeCount(int count) {
        this.ensureArraySize(count - 1);
    }

    public void addProbe(int probeId, SortedIntList lines) {
        this.ensureArraySize(probeId);
        this.probes.set(probeId, lines);
    }

    private void ensureArraySize(int index) {
        while (index >= this.probes.size()) {
            this.probes.add(null);
        }
    }

    public FileCoverageBuilder getFileCoverage(ExecutionData executionData, ILogger logger) throws CoverageGenerationException {
        boolean[] executedProbes = executionData.getProbes();
        if (this.checkProbeInvariant(executedProbes)) {
            throw new CoverageGenerationException("Probe lookup does not match with actual probe size for " + this.sourceFileName + " " + this.className + " (" + this.probes.size() + " vs " + executedProbes.length + ")! This is a bug in the profiler tooling. Please report it back to CQSE.");
        }
        if (this.sourceFileName == null) {
            logger.warn("No source file name found for class " + this.className + "! This class was probably not compiled with debug information enabled!");
            return null;
        }
        String packageName = "";
        if (this.className.contains("/")) {
            packageName = StringUtils.removeLastPart((String)this.className, (char)'/');
        }
        FileCoverageBuilder fileCoverage = new FileCoverageBuilder(packageName, this.sourceFileName);
        this.fillFileCoverage(fileCoverage, executedProbes, logger);
        return fileCoverage;
    }

    private void fillFileCoverage(FileCoverageBuilder fileCoverage, boolean[] executedProbes, ILogger logger) {
        for (int i = 0; i < this.probes.size(); ++i) {
            SortedIntList coveredLines = this.probes.get(i);
            if (!executedProbes[i]) continue;
            if (coveredLines == null) {
                logger.info(this.sourceFileName + " " + this.className + " did contain a covered probe " + i + "(of " + executedProbes.length + ") that could not be matched to any method. This could be a bug in the profiler tooling. Please report it back to CQSE.");
                continue;
            }
            if (coveredLines.isEmpty()) {
                logger.debug(this.sourceFileName + " " + this.className + " did contain a method with no line information. Does the class contain debug information?");
                continue;
            }
            fileCoverage.addLines(coveredLines);
        }
    }

    private boolean checkProbeInvariant(boolean[] executedProbes) {
        return this.probes.size() > executedProbes.length;
    }
}

