/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.model.builder;

import com.teamscale.report.testwise.model.PathCoverage;
import com.teamscale.report.testwise.model.builder.FileCoverageBuilder;
import com.teamscale.report.testwise.model.builder.PathCoverageBuilder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestCoverageBuilder {
    private final String uniformPath;
    private final Map<String, PathCoverageBuilder> pathCoverageList = new HashMap<String, PathCoverageBuilder>();

    public TestCoverageBuilder(String uniformPath) {
        this.uniformPath = uniformPath;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public List<PathCoverage> getPaths() {
        return this.pathCoverageList.values().stream().sorted(Comparator.comparing(PathCoverageBuilder::getPath)).map(PathCoverageBuilder::build).collect(Collectors.toList());
    }

    public void add(FileCoverageBuilder fileCoverage) {
        if (fileCoverage == null || fileCoverage.isEmpty() || fileCoverage.getFileName() == null || fileCoverage.getPath() == null) {
            return;
        }
        PathCoverageBuilder pathCoverage = this.pathCoverageList.computeIfAbsent(fileCoverage.getPath(), PathCoverageBuilder::new);
        pathCoverage.add(fileCoverage);
    }

    public void addAll(List<FileCoverageBuilder> fileCoverageList) {
        for (FileCoverageBuilder fileCoverage : fileCoverageList) {
            this.add(fileCoverage);
        }
    }

    public List<FileCoverageBuilder> getFiles() {
        return this.pathCoverageList.values().stream().flatMap(path -> path.getFiles().stream()).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.pathCoverageList.isEmpty();
    }
}

