/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.testwise.model.builder;

import com.teamscale.client.TestDetails;
import com.teamscale.report.testwise.model.TestExecution;
import com.teamscale.report.testwise.model.TestInfo;
import com.teamscale.report.testwise.model.TestwiseCoverageReport;
import com.teamscale.report.testwise.model.builder.TestCoverageBuilder;
import com.teamscale.report.testwise.model.builder.TestInfoBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class TestwiseCoverageReportBuilder {
    private final Map<String, TestInfoBuilder> tests = new HashMap<String, TestInfoBuilder>();

    public static TestwiseCoverageReport createFrom(Collection<? extends TestDetails> testDetailsList, Collection<TestCoverageBuilder> testCoverage, Collection<TestExecution> testExecutions, boolean partial) {
        TestInfoBuilder container;
        TestwiseCoverageReportBuilder report = new TestwiseCoverageReportBuilder();
        for (TestDetails testDetails : testDetailsList) {
            container = new TestInfoBuilder(testDetails.uniformPath);
            container.setDetails(testDetails);
            report.tests.put(testDetails.uniformPath, container);
        }
        for (TestCoverageBuilder testCoverageBuilder : testCoverage) {
            container = TestwiseCoverageReportBuilder.resolveUniformPath(report, testCoverageBuilder.getUniformPath());
            if (container == null) continue;
            container.setCoverage(testCoverageBuilder);
        }
        for (TestExecution testExecution : testExecutions) {
            container = TestwiseCoverageReportBuilder.resolveUniformPath(report, testExecution.getUniformPath());
            if (container == null) continue;
            container.setExecution(testExecution);
        }
        return report.build(partial);
    }

    private static TestInfoBuilder resolveUniformPath(TestwiseCoverageReportBuilder report, String uniformPath) {
        TestInfoBuilder container = report.tests.get(uniformPath);
        if (container != null) {
            return container;
        }
        String shortenedUniformPath = TestwiseCoverageReportBuilder.stripParameterizedTestArguments(uniformPath);
        TestInfoBuilder testInfoBuilder = report.tests.get(shortenedUniformPath);
        if (testInfoBuilder == null) {
            System.err.println("No container found for test '" + uniformPath + "'!");
        }
        return testInfoBuilder;
    }

    public static String stripParameterizedTestArguments(String uniformPath) {
        return uniformPath.replaceFirst("(.*\\))\\[.*]", "$1");
    }

    private TestwiseCoverageReport build(boolean partial) {
        TestwiseCoverageReport report = new TestwiseCoverageReport(partial);
        ArrayList<TestInfoBuilder> testInfoBuilders = new ArrayList<TestInfoBuilder>(this.tests.values());
        testInfoBuilders.sort(Comparator.comparing(TestInfoBuilder::getUniformPath));
        for (TestInfoBuilder testInfoBuilder : testInfoBuilders) {
            TestInfo testInfo = testInfoBuilder.build();
            if (testInfo == null) {
                System.err.println("No coverage for test '" + testInfoBuilder.getUniformPath() + "'");
                continue;
            }
            report.tests.add(testInfo);
        }
        return report;
    }
}

