/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.util;

import com.teamscale.client.AntPatternUtils;
import com.teamscale.client.FileSystemUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AntPatternIncludeFilter
implements Predicate<String> {
    private final List<Pattern> locationIncludeFilters;
    private final List<Pattern> locationExcludeFilters;

    public AntPatternIncludeFilter(List<String> locationIncludeFilters, List<String> locationExcludeFilters) {
        this.locationIncludeFilters = locationIncludeFilters.stream().map(filter -> AntPatternUtils.convertPattern((String)filter, (boolean)false)).collect(Collectors.toList());
        this.locationExcludeFilters = locationExcludeFilters.stream().map(filter -> AntPatternUtils.convertPattern((String)filter, (boolean)false)).collect(Collectors.toList());
    }

    @Override
    public boolean test(String path) {
        return !this.isFiltered(FileSystemUtils.normalizeSeparators((String)path));
    }

    private boolean isFiltered(String location) {
        if (!this.locationIncludeFilters.isEmpty() && this.locationIncludeFilters.stream().noneMatch(filter -> filter.matcher(location).matches())) {
            return true;
        }
        return this.locationExcludeFilters.stream().anyMatch(filter -> filter.matcher(location).matches());
    }
}

