/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.report.util;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BashFileSkippingInputStream
extends FilterInputStream {
    public BashFileSkippingInputStream(InputStream in) throws IOException {
        super(new BufferedInputStream(in));
        this.consumeUntilZipHeader();
    }

    private void consumeUntilZipHeader() throws IOException {
        byte[] buffer = new byte[8192];
        this.in.mark(buffer.length);
        int count = this.in.read(buffer, 0, buffer.length);
        while (count > 0) {
            for (int i = 0; i < count - 3; ++i) {
                if (buffer[i] != 80 || buffer[i + 1] != 75 || buffer[i + 2] != 3 || buffer[i + 3] != 4) continue;
                this.in.reset();
                this.in.skip(i);
                return;
            }
            this.in.reset();
            this.in.skip(buffer.length - 3);
            this.in.mark(buffer.length);
            count = this.in.read(buffer, 0, buffer.length);
        }
    }
}

