/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import com.teamscale.report.testwise.jacoco.cache.ClassCoverageLookup;
import org.jacoco.core.internal.analysis.CachingInstructionsBuilder;
import org.jacoco.core.internal.analysis.ClassAnalyzer;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.MethodAnalyzer;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

public class CachingClassAnalyzer
extends ClassAnalyzer {
    private final ClassCoverageLookup classCoverageLookup;

    public CachingClassAnalyzer(ClassCoverageLookup classCoverageLookup, ClassCoverageImpl coverage, StringPool stringPool) {
        super(coverage, null, stringPool);
        this.classCoverageLookup = classCoverageLookup;
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.classCoverageLookup.setSourceFileName(source);
    }

    public MethodProbesVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final CachingInstructionsBuilder builder = new CachingInstructionsBuilder(this.classCoverageLookup);
        return new MethodAnalyzer(builder){

            public void accept(MethodNode methodNode, MethodVisitor methodVisitor) {
                super.accept(methodNode, methodVisitor);
                builder.fillCache();
            }
        };
    }

    public void visitTotalProbeCount(int count) {
        this.classCoverageLookup.setTotalProbeCount(count);
    }
}

