/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import java.io.Serializable;
import java.util.Objects;

public class CommitDescriptor
implements Serializable {
    public final String branchName;
    public final String timestamp;

    public CommitDescriptor(String branchName, String timestamp) {
        this.branchName = branchName;
        this.timestamp = timestamp;
    }

    public CommitDescriptor(String branchName, long timestamp) {
        this(branchName, String.valueOf(timestamp));
    }

    public static CommitDescriptor parse(String commit) {
        if (commit.contains(":")) {
            String[] split = commit.split(":");
            return new CommitDescriptor(split[0], split[1]);
        }
        return new CommitDescriptor("master", commit);
    }

    public String toString() {
        return this.branchName + ":" + this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitDescriptor that = (CommitDescriptor)o;
        return Objects.equals(this.branchName, that.branchName) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.branchName, this.timestamp);
    }
}

