/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;
import retrofit2.Retrofit;

public class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);
    private static boolean shouldValidateSsl = false;

    public static void setShouldValidateSsl(boolean shouldValidateSsl) {
        HttpUtils.shouldValidateSsl = shouldValidateSsl;
    }

    public static Retrofit createRetrofit(Consumer<Retrofit.Builder> retrofitBuilderAction) {
        return HttpUtils.createRetrofit(retrofitBuilderAction, okHttpBuilder -> {});
    }

    public static Retrofit createRetrofit(Consumer<Retrofit.Builder> retrofitBuilderAction, Consumer<OkHttpClient.Builder> okHttpBuilderAction) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        HttpUtils.setDefaults(httpClientBuilder);
        HttpUtils.setUpSslValidation(httpClientBuilder);
        okHttpBuilderAction.accept(httpClientBuilder);
        Retrofit.Builder builder = new Retrofit.Builder().client(httpClientBuilder.build());
        retrofitBuilderAction.accept(builder);
        return builder.build();
    }

    private static void setDefaults(OkHttpClient.Builder builder) {
        builder.connectTimeout(60L, TimeUnit.SECONDS);
        builder.readTimeout(60L, TimeUnit.SECONDS);
        builder.writeTimeout(60L, TimeUnit.SECONDS);
    }

    private static void setUpSslValidation(OkHttpClient.Builder builder) {
        SSLSocketFactory sslSocketFactory;
        if (shouldValidateSsl) {
            return;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{TrustAllCertificatesManager.INSTANCE}, new SecureRandom());
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not disable SSL certificate validation. Leaving it enabled", (Throwable)e);
            return;
        }
        builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)TrustAllCertificatesManager.INSTANCE);
        builder.hostnameVerifier((hostName, session) -> true);
    }

    public static <T> String getErrorBodyStringSafe(Response<T> response) throws IOException {
        ResponseBody errorBody = response.errorBody();
        if (errorBody == null) {
            return "<no response body provided>";
        }
        return errorBody.string();
    }

    public static Interceptor getBasicAuthInterceptor(String username, String password) {
        String credentials = username + ":" + password;
        String basic = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes());
        return chain -> {
            Request newRequest = chain.request().newBuilder().header("Authorization", basic).build();
            return chain.proceed(newRequest);
        };
    }

    public static class TrustAllCertificatesManager
    implements X509TrustManager {
        static final TrustAllCertificatesManager INSTANCE = new TrustAllCertificatesManager();

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

